//
//  RepairOrderAddTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import ImagePicker
import SKPhotoBrowser
import RxSwift
import RxCocoa

class RepairOrderAddTableViewController: BaseTableViewController {
    
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 来源
    @IBOutlet weak var sourceLabel: UILabel!
    /// 服务类型
    @IBOutlet weak var serviceTypeLabel: UILabel!
    /// 优先级
    @IBOutlet weak var priorityLabel: UILabel!
    /// 报事人
    @IBOutlet weak var originatorLabel: UILabel!
    /// 接报时间
    @IBOutlet weak var originatorTimeLabel: UILabel!
    /// 指定时间
    @IBOutlet weak var specifiedTimeLabel: UILabel!
    /// 位置
    @IBOutlet weak var specifiedLocationLabel: UILabel!
    /// 设施信息
    @IBOutlet weak var facilitiesSwitch: UISwitch!
    /// 联系电话
    @IBOutlet weak var phoneNumberText: UITextField!
    /// 工单描述
    @IBOutlet weak var describeTextView: IQTextView!
    /// 图片附件高度
    var attachmentHeight: CGFloat! = 0
    /// 默认section高度
    let sectionHeight: CGFloat! = 30
    
    /// 图片附件
    lazy final var attachmentVc: PhotoAttachmentViewController = {
       var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        attachmentVc.delegate = self
        return attachmentVc
    }()
    
    /// RepairOrderViewModel
    lazy final var repairOrderViewModel: RepairOrderViewModel = {
        var repairOrderViewModel = RepairOrderViewModel()
        return repairOrderViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        setupPhotoAttachmentVc()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        describeTextView.placeholder = "工单描述"
        tableView.register(UINib(nibName: RepairAttachmentTableViewCell.name(), bundle: nil), forCellReuseIdentifier: RepairAttachmentTableViewCell.name())
    }
    
    // MARK: - 设置附件VC
    fileprivate func setupPhotoAttachmentVc(){
        addChildViewController(attachmentVc)
        attachmentVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel("add_photo", .ATTACHMENT_ADD))
        attachmentHeight = attachmentVc.attachmentHeight(kONE)
    }
    
    // MARK: - 绑定RxSwift事件
    fileprivate func bindingRxAction() {
        facilitiesSwitch.rx.controlEvent(UIControlEvents.valueChanged).subscribe(onNext: {[weak self] (event) in
            self?.tableView.reloadData()
        }).disposed(by: disposeBag)
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            let attachmentCell = tableView.dequeueReusableCell(withIdentifier: RepairAttachmentTableViewCell.name(), for: indexPath) as! RepairAttachmentTableViewCell
            attachmentVc.view.frame = CGRect(x: 15, y: 35, width: kWidth - 30, height: attachmentHeight)
            attachmentCell.contentView.addSubview(attachmentVc.view)
            return attachmentCell
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            return attachmentHeight + 50
        }
        return super.tableView(tableView, heightForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue && !facilitiesSwitch.isOn {
            return kZERO
        }
        if section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            return kONE
        }
        return super.tableView(tableView, numberOfRowsInSection: section)
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == REPAIR_ORDER_SECTION.BASIC.rawValue {
            return sectionHeight
        }
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue {
            if facilitiesSwitch.isOn {
                return sectionHeight
            }
            return CGFloat(0.01)
        }
        return 10
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return CGFloat(0.01)
    }
    
    override func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue && !facilitiesSwitch.isOn {
            return UIView()
        }
        return super.tableView(tableView, viewForHeaderInSection: section)
    }
}

extension RepairOrderAddTableViewController: PhotoAttachmentDelegate {
    func updatePhotoAttachment(_ height: CGFloat) {
        attachmentHeight = height
        tableView.reloadData()
    }
}












