//
//  AccountTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import Kingfisher

class AccountTableViewController: BaseTableViewController {

    /// 用户头像
    @IBOutlet weak var userHeaderImg: UIImageView!
    /// 用户名
    @IBOutlet weak var userNameLab: UILabel!
    /// 账户背景
    @IBOutlet weak var accountBgView: UIView!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        uiConfigAction()
        dataAction()
    }

    // MARK: - 状态栏风格
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .lightContent
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        self.fd_prefersNavigationBarHidden = true
        userHeaderImg.addAngle(kWidth * 0.15 * 0.5)
        userHeaderImg.addBorder(1.0, UIColor.white)
        accountBgView.seth(h: kWidth * 9 / 16)
    }
    
    // MARK: - 填充数据
    fileprivate func dataAction() {
        userNameLab.text = "曹云霄"
        userHeaderImg.kf.setImage(with: URL(string: "https://upload.jianshu.io/users/upload_avatars/1603648/59f165f01901.jpg?imageMogr2/auto-orient/strip|imageView2/1/w/240/h/240"))
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 10
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
    }
}






















