//
//  UIViewController+Extension.swift
//  CStoreEdu-iOS
//
//  Created by 曹云霄 on 2017/3/10.
//  Copyright © 2017年 上海勾芒信息科技有限公司. All rights reserved.
//

import Foundation
import UIKit


public enum StoryboardType: String {
    case Main = "Main"
    case Home = "Home"
    case Function = "Function"
    case Me = "Me"
}


extension UIViewController {
    
    // MARK: -返回storyboard对象
    class func instantiateViewController(_ storyBoardName: StoryboardType) -> UIViewController {
        let storyBoard = UIStoryboard(name: storyBoardName.rawValue, bundle: nil)
        return storyBoard.instantiateViewController(withIdentifier: "\(self)")
    }
    
    // MARK: -返回控制器名称
    class func name() -> String {
        return "\(self)"
    }
}








