//
//  String+Extension.swift
//  CStoreEdu-iOS
//
//  Created by 曹云霄 on 2017/3/21.
//  Copyright © 2017年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

extension NSString {
    
    // 计算字符串的宽度，高度
    open func calculateStringSize(_ size: CGSize,font: UIFont) ->CGSize {
        let attributes = [NSAttributedStringKey.font:font]
        let option = NSStringDrawingOptions.usesLineFragmentOrigin
        let rect:CGRect = self.boundingRect(with:CGSize(width: kWidth, height: kHeight) , options: option, attributes: attributes, context: nil)
        return rect.size
    }
    
    // 去掉字符串前后空格
    open func formatString() -> String {
        let set = NSCharacterSet.whitespacesAndNewlines
        return self.trimmingCharacters(in: set)
    }
    
    // MARK: - 富文本设置颜色
    open func attributeString(_ colorString: String,_ color: UIColor) ->NSMutableAttributedString {
        let range = self.range(of: colorString)
        //富文本设置
        let attributeString = NSMutableAttributedString(string:self as String)
        //设置字体颜色
        attributeString.addAttribute(NSAttributedStringKey.foregroundColor, value: color,range: range)
        return attributeString
    }
    
    // MARK: - 带¥符号字符串
    open func priceString() -> String {
        return  String(format: "¥%.2f", self.floatValue)
    }
    
    
    // MARK: - 获取路径文件大小
    open func getFileSize() -> UInt64  {
        var size: UInt64 = 0
        let fileManager = FileManager.default
        var isDir: ObjCBool = false
        let isExists = fileManager.fileExists(atPath: self as String, isDirectory: &isDir)
        // 判断文件存在
        if isExists {
            // 是否为文件夹
            if isDir.boolValue {
                // 迭代器 存放文件夹下的所有文件名
                let enumerator = fileManager.enumerator(atPath: self as String)
                for subPath in enumerator! {
                    // 获得全路径
                    let fullPath = self.appending("/\(subPath)")
                    do {
                        let attr = try fileManager.attributesOfItem(atPath: fullPath)
                        size += attr[FileAttributeKey.size] as! UInt64
                    } catch  {
                        print("error :\(error)")
                    }
                }
            } else {    // 单文件
                do {
                    let attr = try fileManager.attributesOfItem(atPath: self as String)
                    size += attr[FileAttributeKey.size] as! UInt64
                    
                } catch  {
                    print("error :\(error)")
                }
            }
        }
        return size
    }

}

