//
//  BaseTableViewPullController.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/8.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import MJRefresh
import DZNEmptyDataSet


class BaseTableViewPullController: BaseViewController {

    /// 公共Tableview    
    @IBOutlet weak var tableView: UITableView!
    /// 分页下标
    final var pullPageIndex: Int = kONE
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        setupTableView()
        setupTableViewHeader()
        setupTableViewFooter()
    }

    // MARK: - 设置TableView
    func setupTableView() {
        tableView.delegate = self
        tableView.dataSource = self
        tableView.tableFooterView = UIView()
        tableView.register(UINib(nibName: EmptyTableViewCell.name(), bundle: nil), forCellReuseIdentifier: EmptyTableViewCell.name())
    }
    
    // MARK: - 加载网络数据  需要重载
    func loadWebDataSource() {
        if tableView.isEmptyDataSetVisible {
            tableView.reloadEmptyDataSet()
        }
    }
    
    // MARK: - 添加下拉刷新
    func setupTableViewHeader() {
        let header = MJRefreshNormalHeader(refreshingTarget: self, refreshingAction: #selector(BaseTableViewPullController.loadTableViewHeader))
        header?.lastUpdatedTimeLabel.isHidden = true
        header?.stateLabel.isHidden = true
        header?.stateLabel.textColor = kNavColor
        header?.beginRefreshing()
        tableView.mj_header = header
    }
    
    // MARK: - 添加上拉加载更多
    func setupTableViewFooter() {
        let footer = MJRefreshAutoNormalFooter.init(refreshingTarget: self, refreshingAction: #selector(BaseTableViewPullController.loadTableViewFooter))
        footer?.setTitle("~ 加载更多 ~", for: .idle)
        footer?.setTitle("~ 加载中 ~", for: .refreshing)
        footer?.setTitle("~ end ~", for: .noMoreData)
        footer?.stateLabel.textColor = kNavColor
        tableView.mj_footer = footer
    }
    
    // MARK: - 上拉加载回调
    @objc func loadTableViewFooter() {
        setupNotDataDelegate()
        pullPageIndex += kONE
        loadWebDataSource()
    }
    
    // MARK: - 下拉刷新回调
    @objc func loadTableViewHeader() {
        setupNotDataDelegate()
        tableView.mj_footer.resetNoMoreData()
        pullPageIndex = kONE
        loadWebDataSource()
    }
    
    // MARK: - 设置无数据代理
    final func setupNotDataDelegate() {
        tableView.emptyDataSetSource = self
        tableView.emptyDataSetDelegate = self
    }
    
    // MARK: - 结束刷新
    func endRefresh() {
        if tableView.mj_header.isRefreshing {
            tableView.mj_header.endRefreshing()
        }
        if tableView.mj_footer.isRefreshing {
            tableView.mj_footer.endRefreshing()
        }
    }
    
    // MARK: - 结束刷新切显示无更多的数据
    func endRefreshNomoreData() {
        endRefresh()
        tableView.mj_footer.endRefreshingWithNoMoreData()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
}


extension BaseTableViewPullController: DZNEmptyDataSetSource,DZNEmptyDataSetDelegate {

    func image(forEmptyDataSet scrollView: UIScrollView!) -> UIImage! {
        return UIImage(named: "logo-github")
    }
    
    func description(forEmptyDataSet scrollView: UIScrollView!) -> NSAttributedString! {
        let dict: [NSAttributedStringKey: Any] = [NSAttributedStringKey.font: UIFont.systemFont(ofSize: 15),NSAttributedStringKey.foregroundColor: kNavColor]
        let attrString = NSAttributedString(string: "对不起，真的没有数据!", attributes: dict)
        return attrString
    }
    
    func emptyDataSetShouldAllowScroll(_ scrollView: UIScrollView!) -> Bool {
        return true
    }
}

extension BaseTableViewPullController: UITableViewDataSource,UITableViewDelegate {
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return UITableViewCell()
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return kONE
    }
}















