//
//  BaseColletionViewPullController.Swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/8.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import MJRefresh
import DZNEmptyDataSet

class BaseColletionViewPullController: BaseViewController {

    
    /// 公共CollectionView
    @IBOutlet final weak var collectionView: UICollectionView!
    
    /// 分页下标
    final var pullPageIndex: Int = 1
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupCollectionView()
        setupCollectionViewHeader()
        setupCollectionViewFooter()
    }
    
    // MARK: - 设置CollectionView
    fileprivate final func setupCollectionView() {
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.alwaysBounceVertical = true
    }
    
    // MARK: - 加载网络数据  需要重载
    func loadWebDataSource() {
        if collectionView.isEmptyDataSetVisible {
            collectionView.reloadEmptyDataSet()
        }
    }
    
    // MARK: - 添加下拉刷新
    func setupCollectionViewHeader() {
        let header = MJRefreshNormalHeader(refreshingTarget: self, refreshingAction: #selector(BaseColletionViewPullController.loadCollectionViewHeader))
        header?.lastUpdatedTimeLabel.isHidden = true
        header?.stateLabel.isHidden = true
        header?.stateLabel.textColor = kNavColor
        collectionView.mj_header = header
    }
    
    // MARK: - 添加上拉加载更多
    func setupCollectionViewFooter() {
        let footer = MJRefreshAutoNormalFooter.init(refreshingTarget: self, refreshingAction: #selector(BaseColletionViewPullController.loadCollectionViewFooter))
        footer?.setTitle("~ 加载更多 ~", for: .idle)
        footer?.setTitle("~ 加载中 ~", for: .refreshing)
        footer?.setTitle("~ end ~", for: .noMoreData)
        footer?.stateLabel.textColor = kNavColor
        collectionView.mj_footer = footer
    }
    
    // MARK: - 上拉加载回调
    @objc func loadCollectionViewFooter() {
        setupNotDataDelegate()
        pullPageIndex += kONE
        loadWebDataSource()
    }
    
    // MARK: - 下拉刷新回调
    @objc func loadCollectionViewHeader() {
        setupNotDataDelegate()
        collectionView.mj_footer.resetNoMoreData()
        pullPageIndex = kZERO
        loadWebDataSource()
    }
    
    // MARK: - 设置无数据代理
    final func setupNotDataDelegate() {
        collectionView.emptyDataSetSource = self
        collectionView.emptyDataSetDelegate = self
    }
    
    // MARK: - 结束刷新
    func endRefresh() {
        if collectionView.mj_header.isRefreshing {
            collectionView.mj_header.endRefreshing()
        }
        if collectionView.mj_footer.isRefreshing {
            collectionView.mj_footer.endRefreshing()
        }
    }
    
    // MARK: - 结束刷新切显示无更多的数据
    func endRefreshNomoreData() {
        collectionView.mj_footer.endRefreshingWithNoMoreData()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
}


extension BaseColletionViewPullController: DZNEmptyDataSetSource,DZNEmptyDataSetDelegate {
    
    func image(forEmptyDataSet scrollView: UIScrollView!) -> UIImage! {
        return UIImage(named: "logo-github")
    }
    
    func description(forEmptyDataSet scrollView: UIScrollView!) -> NSAttributedString! {
        let dict: [NSAttributedStringKey: Any] = [NSAttributedStringKey.font: UIFont.systemFont(ofSize: 15),NSAttributedStringKey.foregroundColor: kNavColor]
        let attrString = NSAttributedString(string: "对不起，真的没有数据!", attributes: dict)
        return attrString
    }
    
    func emptyDataSetShouldAllowScroll(_ scrollView: UIScrollView!) -> Bool {
        return true
    }
}

extension BaseColletionViewPullController: UICollectionViewDataSource,UICollectionViewDelegate {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return kONE
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        return UICollectionViewCell()
    }
}
