//
//  MBProgressHUD+Addtions.m
//  RealEstateManagement
//
//  Created by Z on 16/6/24.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "MBProgressHUD+Addtions.h"

//hud 延迟多久消失
static CGFloat const delay = 1.2;

@implementation MBProgressHUD (Addtions)
+ (MBProgressHUD *)Javen_showSuccess:(NSString *)success onView:(UIView *)view delay:(NSTimeInterval)time complete:(void (^)(void))complete {
    [[UIApplication sharedApplication].keyWindow endEditing:YES];
    MBProgressHUD *hud = [[MBProgressHUD alloc] initWithView:view];
    [view addSubview:hud];

    UIImage *image = [[UIImage imageNamed:@"Checkmark"] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    imageView.tintColor = [UIColor whiteColor];
    hud.customView = imageView;
    hud.mode = MBProgressHUDModeCustomView;
    hud.label.text = success;
    [hud showAnimated:YES];

    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(time * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{

        [hud removeFromSuperview];

        if (complete) {
            complete();
        }
    });
    return hud;
}

+ (void)Javen_showError:(NSString *)error onView:(UIView *)view delay:(NSTimeInterval)time complete:(void (^)(void))complete {
    [[UIApplication sharedApplication].keyWindow endEditing:YES];
    MBProgressHUD *hud = [[MBProgressHUD alloc] initWithView:view];
    [view addSubview:hud];

    UIImage *image = [[UIImage imageNamed:@"cross"] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    imageView.tintColor = [UIColor whiteColor];
    hud.customView = imageView;
    hud.mode = MBProgressHUDModeCustomView;
    hud.label.text = error;
    [hud showAnimated:YES];

    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(time * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [hud removeFromSuperview];

        if (complete) {
            complete();
        }
    });
}

+ (MBProgressHUD *)JVShowMessage:(NSString *)message onView:(UIView *)view autoDisppear:(BOOL)autoDisppear {
    if (message.length < 1 || message == nil) {
        return nil;
    }
    MBProgressHUD *hud = [[MBProgressHUD alloc] initWithView:view];
    hud.mode = MBProgressHUDModeText;
    hud.label.text = message;
    [view addSubview:hud];
    [hud showAnimated:YES];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.7 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [hud removeFromSuperview];
    });
    return hud;
}

//创建一个hud 配置hud样式
+ (MBProgressHUD *)j_hudWithView:(UIView *)view {
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:view animated:YES];
    hud.animationType = MBProgressHUDAnimationZoomOut;
    hud.contentColor = kMainColor;
    hud.label.font = [UIFont systemFontOfSize:18];
    hud.detailsLabel.font = [UIFont systemFontOfSize:16];
    hud.removeFromSuperViewOnHide = YES;
    return hud;
}

//成功的hud
+ (void)j_success:(NSString *)success complete:(void (^)(void))complete {
    [self j_customViewImageName:@"Checkmark" text:success complete:complete];
}

//失败的hud
+ (void)j_error:(NSString *)error complete:(void (^)(void))complete {
    [self j_customViewImageName:@"cross" text:error complete:complete];
}

//自定义hud图片
+ (MBProgressHUD *)j_customViewImageName:(NSString *)imageName text:(NSString *)text complete:(void (^)(void))complete{
    [self j_removeAllHud];
    MBProgressHUD *hud = [self j_hudWithView:[UIApplication sharedApplication].keyWindow];
    hud.mode = MBProgressHUDModeCustomView;
    UIImage *image = [[UIImage imageNamed:imageName] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    imageView.tintColor = kMainColor;
    hud.customView = imageView;
    hud.detailsLabel.text = text;
    [hud showAnimated:YES];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(delay * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self j_hideLoadingView];
        if (complete) {
            complete();
        }
    });
    return hud;
}

/**
 *  只有菊花
 */
+ (void)j_loading {
    [self j_removeAllHud];
    MBProgressHUD *hud = [self j_hudWithView:[UIApplication sharedApplication].keyWindow];
    [hud showAnimated:YES];
}

/**
 *  菊花+文字
 *
 *  @param text 提示文字
 */
+ (void)j_loading:(NSString *)text {
    [self j_removeAllHud];
    MBProgressHUD *hud = [self j_hudWithView:[UIApplication sharedApplication].keyWindow];
    hud.label.text = text;
    [hud showAnimated:YES];
}

/**
 *  仅文字提示  自动消失
 *
 *  @param text 提示文字
 */
+ (void)j_textOnly:(NSString *)text {
    [self j_removeAllHud];
    MBProgressHUD *hud = [self j_hudWithView:[UIApplication sharedApplication].keyWindow];
    hud.mode = MBProgressHUDModeText;
    hud.label.text = text;
    [hud showAnimated:YES];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(delay * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self j_hideLoadingView];
    });
}


/**
 *  隐藏[UIApplication sharedApplication].keyWindow上面的所有hud
 */
+ (void)j_hideLoadingView {
    MBProgressHUD *hud;
    for (id view in [UIApplication sharedApplication].keyWindow.subviews) {
        if ([view isKindOfClass:[MBProgressHUD class]]) {
            hud = view;
            [hud hideAnimated:YES];
            hud = nil;
        }
    }
}

/**
 *  删除所有hud
 */
+ (void)j_removeAllHud {
    for (id view in [UIApplication sharedApplication].keyWindow.subviews) {
        if ([view isKindOfClass:[MBProgressHUD class]]) {
            MBProgressHUD *hud = view;
            [hud removeFromSuperview];
            hud = nil;
        }
    }
}

@end
