//
//  BaseListViewController.m
//  RealEstateManagement
//
//  Created by Javen on 16/9/8.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "BaseListViewController.h"
@interface BaseListViewController ()

@end

@implementation BaseListViewController

#pragma mark - life cycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    self.pageSize = 15;
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.emptyDataSetSource = self;
    self.tableView.emptyDataSetDelegate = self;
    self.tableView.estimatedRowHeight = 159;
    self.tableView.rowHeight = UITableViewAutomaticDimension;
    self.tableView.tableFooterView = [UIView new];
    [self paggingMode];
    // Do any additional setup after loading the view.
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:YES];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/**
 *  启用分页加载（最好在ViewDidLoad里面调用）
 */
- (void)paggingMode
{
    WS(weakSelf);
    self.tableView.mj_header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        weakSelf.page = 0;
        [weakSelf.arrData removeAllObjects];
        /**
         *  子类里面要重写httpRequest方法
         */
        [MBProgressHUD j_loading];
        [weakSelf httpRequest];
    }];

    self.tableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        weakSelf.page++;
        [weakSelf httpRequest];
    }];
    self.tableView.mj_footer.hidden = YES;
}

- (void)refresh
{
    [self.tableView.mj_header beginRefreshing];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.arrData.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    [self listDidSelect:self.arrData[indexPath.row]];
}

#pragma mark - empty state
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return [UIImage imageNamed:@"list_no_data"];
}

- (void)emptyDataSet:(UIScrollView *)scrollView didTapView:(UIView *)view
{
    [self.tableView.mj_header beginRefreshing];
}
- (CAAnimation *)imageAnimationForEmptyDataSet:(UIScrollView *)scrollView
{
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath:@"transform"];
    animation.fromValue = [NSValue valueWithCATransform3D:CATransform3DIdentity];
    animation.toValue = [NSValue valueWithCATransform3D:CATransform3DMakeRotation(M_PI_2, 0.0, 0.0, 1.0)];
    animation.duration = 1;
    animation.cumulative = YES;
    animation.repeatCount = MAXFLOAT;

    return animation;
}

- (UIColor *)backgroundColorForEmptyDataSet:(UIScrollView *)scrollView
{
    return [UIColor whiteColor];
}

- (IBAction)actionAdd:(UIButton *)sender
{
}

- (void)listTableViewReloadData
{
    [MBProgressHUD j_hideLoadingView];
    [self.tableView reloadData];
    [self.tableView j_endRefresh];
    self.tableView.mj_footer.hidden = self.arrData.count == 0;
  if (self.arrData.count < self.pageSize * self.page) {
    [self.tableView.mj_footer endRefreshingWithNoMoreData];
  }
}

- (void)listTableViewReloadDataWithNewRecord:(NSArray *)newRecord
{
    [self listTableViewReloadData];
    CLog(@"newrecord count = %lu", newRecord.count);
    if ([newRecord count] < self.pageSize) {
        [self.tableView.mj_footer endRefreshingWithNoMoreData];
    }
}
- (NSMutableArray *)arrData
{
    if (!_arrData) {
        _arrData = [NSMutableArray array];
    }
    return _arrData;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
