
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  排序方向。
 *
 *  @author Debenson
 *  @since 0.0.1
 */
/**
 * 升序
 */
extern NSString * const QUERYORDERDIRECTION_ASC;
/**
 * 降序
 */
extern NSString * const QUERYORDERDIRECTION_DESC;




@class QueryOrder;
@class QueryResultPaging;
@class QueryDefinition;
@class RsQueryResult;
@class LoginRequest;
@class ModifyPasswordRequest;
@class ResetPasswordRequest;
@class CheckTicketRequest;
@class StationUserAcctHisEntity;
@class DelegateCardBalanceEntity;
@class CommentEntity;
@class GasItemEntity;
@class MemberEntity;
@class RechargeBillEntity;
@class OrderEntity;
@class WxAccountMgrEntity;
@class WxKfAccountEntity;
@class WxMediaEntity;
@class IdEntity;
@class ComboBox;
@class Highchart;
@class ValidForm;
@class CgFormFieldEntity;
@class CgFormIndexEntity;
@class GoodsEntity;
@class FileMeta;
@class TableJson;
@class CgFormHeadEntity;
@class AjaxJson;
@class TreeGrid;
@class ComboTree;
@class AjaxJson;
@class WxTagEntity;
@class WxFansEntity;
@class OtherTicketEntity;
@class InvoiceEntity;
@class DelegateCardEntity;
@class DrawCashBillEntity;
@class TOAppversionEntity;
@class StationUserAcctEntity;
@class LoginResult;
@class RsResponse;
@class ExceptionCode;
@class AlipayGzuserinfo;
@class OrderQueryResult;
@class WithdrawQueryResult;
@class JeecgDemo;
@class TSDepart;
@class TSBaseUser;
@class TSUserOrg;
@class OrderQueryDefintion;
@class WxMassBillEntity;
@class WithdrawQueryDefintion;
@class AccountHistoryQueryResult;
@class AccountHistoryQueryDefintion;
@class TSUser;
@class StationEntity;
@class StationUserEntity;

@protocol QueryOrder @end
@protocol QueryResultPaging @end
@protocol QueryDefinition @end
@protocol RsQueryResult @end
@protocol LoginRequest @end
@protocol ModifyPasswordRequest @end
@protocol ResetPasswordRequest @end
@protocol CheckTicketRequest @end
@protocol StationUserAcctHisEntity @end
@protocol DelegateCardBalanceEntity @end
@protocol CommentEntity @end
@protocol GasItemEntity @end
@protocol MemberEntity @end
@protocol RechargeBillEntity @end
@protocol OrderEntity @end
@protocol WxAccountMgrEntity @end
@protocol WxKfAccountEntity @end
@protocol WxMediaEntity @end
@protocol IdEntity @end
@protocol ComboBox @end
@protocol Highchart @end
@protocol ValidForm @end
@protocol CgFormFieldEntity @end
@protocol CgFormIndexEntity @end
@protocol GoodsEntity @end
@protocol FileMeta @end
@protocol TableJson @end
@protocol CgFormHeadEntity @end
@protocol AjaxJson @end
@protocol TreeGrid @end
@protocol ComboTree @end
@protocol AjaxJson @end
@protocol WxTagEntity @end
@protocol WxFansEntity @end
@protocol OtherTicketEntity @end
@protocol InvoiceEntity @end
@protocol DelegateCardEntity @end
@protocol DrawCashBillEntity @end
@protocol TOAppversionEntity @end
@protocol StationUserAcctEntity @end
@protocol LoginResult @end
@protocol RsResponse @end
@protocol ExceptionCode @end
@protocol AlipayGzuserinfo @end
@protocol OrderQueryResult @end
@protocol WithdrawQueryResult @end
@protocol JeecgDemo @end
@protocol TSDepart @end
@protocol TSBaseUser @end
@protocol TSUserOrg @end
@protocol OrderQueryDefintion @end
@protocol WxMassBillEntity @end
@protocol WithdrawQueryDefintion @end
@protocol AccountHistoryQueryResult @end
@protocol AccountHistoryQueryDefintion @end
@protocol TSUser @end
@protocol StationEntity @end
@protocol StationUserEntity @end


/**
 *  查询排序条件。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryOrder : JSONModel
/**
 * 字段名称
 *
 *
 */
@property (nonatomic, copy) NSString *field;
/**
 * 排序方向
 *
 * 取值: QUERYORDERDIRECTION_ASC, QUERYORDERDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *direction;
@end /* interface QueryOrder */



/**
 *  分页数据。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryResultPaging : JSONModel
/**
 * 当前页数，起始于0
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数，传0表示查询所有记录
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 查询结果总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 查询结果总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface QueryResultPaging */



/**
 *  查询定义。
 
 <br>
 查询定义的基类，具体查询条件由子类实现。
 
 @author Debenson
 @since 0.1
 
 */
@interface QueryDefinition : JSONModel
/**
 * 排序条件
 * @see QueryOrder
 *
 */
@property (nonatomic, strong) NSArray<QueryOrder> *orders;
/**
 * 页数，表示查询第几页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageNumber;
/**
 * 每页的记录数，传0表示查询所有数据不分页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
@end /* interface QueryDefinition */



/**
 *  查询结果。
 
 <br>
 查询结果基类， 具体结果集合由子类定义。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface RsQueryResult : JSONModel
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) QueryResultPaging *paging;
/**
 * 当前页数
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface RsQueryResult */



/**
 *  加油员登录请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginRequest : JSONModel
/**
 * 用户名，不可空
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 密码，不可空
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * 当前经度 ，可空
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * 当前纬度 ，可空
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
@end /* interface LoginRequest */



/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 加油员用户名。
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */



/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 加油员用户名。
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 短信验证码，请先调用发送短信接口
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */



/**
 *  核券请求
 
 @author liyang
 @since 0.1
 
 */
@interface CheckTicketRequest : JSONModel
/**
 * 券号
 *
 *
 */
@property (nonatomic, copy) NSString *ticketNumber;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkManName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *checkDate;
@end /* interface CheckTicketRequest */



/**
 *  @Title: Entity
 @Description: 加油员账户流水
 @author onlineGenerator
 @date 2016-11-17 19:48:43
 @version V1.0
 
 
 */
@interface StationUserAcctHisEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 方法: 取得变化前余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *oldBalance;
/**
 * 方法: 取得发生额
 *
 *
 */
@property (nonatomic, strong) NSNumber *occur;
/**
 * 方法: 取得变化后余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *fnewBalance;
/**
 * 方法: 取得业务单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得业务动作
 *
 *
 */
@property (nonatomic, copy) NSString *action;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 方法: 取得交易编号
 *
 *
 */
@property (nonatomic, assign) NSInteger tradeNo;
@end /* interface StationUserAcctHisEntity */



/**
 *  @Title: Entity
 @Description: 代管卡余额变化记录
 @author onlineGenerator
 @date 2017-01-06 10:36:48
 @version V1.0
 
 
 */
@interface DelegateCardBalanceEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 业务单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 原金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *originalAmount;
/**
 * 变化金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *changeAmount;
/**
 * 变化金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *balanceAmount;
/**
 * 代管卡��号
 *
 *
 */
@property (nonatomic, copy) NSString *cardNumber;
/**
 * 方法: 取得支付方式
 *
 *
 */
@property (nonatomic, copy) NSString *payMethod;
/**
 * 方法: 取得支付流水号
 *
 *
 */
@property (nonatomic, copy) NSString *payFlowNum;
/**
 * 方法: 取得单据状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 获取审核人id
 *
 *
 */
@property (nonatomic, copy) NSString *checkerId;
/**
 * 方法: 获取审核人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *checkerName;
/**
 * 方法: 获取审核日期
 *
 *
 */
@property (nonatomic, copy) NSString *checkDate;
/**
 * 方法: 获取油站名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationName;
@end /* interface DelegateCardBalanceEntity */



/**
 *  @Title: Entity
 @Description: 点评记录
 @author onlineGenerator
 @date 2016-11-30 14:32:53
 @version V1.0
 
 
 */
@interface CommentEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 所属加油单
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 油站id
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
/**
 * 油站名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationName;
/**
 * 加油员id
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserId;
/**
 * 加油员姓名
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserName;
/**
 * 会员id
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 点评时间
 *
 *
 */
@property (nonatomic, copy) NSString *commentDate;
@end /* interface CommentEntity */



/**
 *  @Title: Entity
 @Description: 油品
 @author onlineGenerator
 @date 2016-11-17 19:34:17
 @version V1.0
 
 
 */
@interface GasItemEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得编码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface GasItemEntity */



/**
 *  @Title: Entity
 @Description: 车主会员
 @author onlineGenerator
 @date 2016-11-17 19:45:26
 @version V1.0
 
 
 */
@interface MemberEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * ���法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *idno;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *mobilephone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *wxid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *alipayid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *grade;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *imgurl;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *defCarNo;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *lstLoginTime;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger errLoginTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *status;
@end /* interface MemberEntity */



/**
 *
 @Title: Entity
 @Description: 代管卡充值单
 @author onlineGenerator
 @date 2017-01-06 10:17:23
 @version V1.0
 
 
 */
@interface RechargeBillEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 代管卡卡号
 *
 *
 */
@property (nonatomic, copy) NSString *cardNumber;
/**
 * 充值人id
 *
 *
 */
@property (nonatomic, copy) NSString *rechargeUserId;
/**
 * 充值人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *rechargeUserName;
/**
 * 充值时间
 *
 *
 */
@property (nonatomic, copy) NSString *rechargeTime;
/**
 * 原金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *originalAmount;
/**
 * 充值金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *rechargeAmount;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 充值单单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得充值单状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface RechargeBillEntity */



/**
 *  @Title: Entity
 @Description: 加油单
 @author onlineGenerator
 @date 2016-11-17 19:48:57
 @version V1.0
 
 
 */
@interface OrderEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得油站标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
/**
 * 方法: 取得油站名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationName;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserId;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserName;
/**
 * 方法: 取得加油员真实姓名
 *
 *
 */
@property (nonatomic, copy) NSString *stationUserRealName;
/**
 * 方法: 取得会员标识
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 方法: 取得会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 方法: 取得会员手机号
 *
 *
 */
@property (nonatomic, copy) NSString *memberMobilephone;
/**
 * 方法: 取得油枪标识
 *
 *
 */
@property (nonatomic, copy) NSString *oilGunId;
/**
 * 方法: 取得油枪名称
 *
 *
 */
@property (nonatomic, copy) NSString *oilGunName;
/**
 * 方法: 取得油品标识
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemId;
/**
 * 方法: 取得油品名称
 *
 *
 */
@property (nonatomic, copy) NSString *gasItemName;
/**
 * 方法: 取得订单总金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
/**
 * 方法: 取得实付金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realPayTotal;
/**
 * 方法: 取得支付时间
 *
 *
 */
@property (nonatomic, copy) NSString *payTime;
/**
 * 方法: 取得支付方式
 *
 *
 */
@property (nonatomic, copy) NSString *payMethod;
/**
 * 方法: 取得销售提成
 *
 *
 */
@property (nonatomic, strong) NSNumber *deduct;
/**
 * 方法: 取得是否开票
 *
 *
 */
@property (nonatomic, copy) NSString *invoice;
/**
 * 方法: 取得小票打印次数
 *
 *
 */
@property (nonatomic, assign) NSInteger printed;
/**
 * 方法: 取得最后打印时间
 *
 *
 */
@property (nonatomic, copy) NSString *lstPrintedTime;
/**
 * 方法: 取得支付流水号
 *
 *
 */
@property (nonatomic, copy) NSString *payFlowNum;
/**
 * 方法: 取得订单状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *vehicleNo;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *payFailedMsg;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printState;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *invoiceId;
/**
 * 买家支付宝用户号
 *
 *
 */
@property (nonatomic, copy) NSString *alipayBuyerId;
/**
 * 买家支付宝账号
 *
 *
 */
@property (nonatomic, copy) NSString *alipaybuyerLogonId;
@end /* interface OrderEntity */



/**
 *  @Title: Entity
 @Description: 公众号管理员
 @author onlineGenerator
 @date 2016-11-19 21:33:00
 @version V1.0
 
 
 */
@interface WxAccountMgrEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, assign) BOOL active;
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得公众号标识
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 方法: 取得用户标识
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 方法: 取得用户名
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 方法: 取得真实姓名
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
@end /* interface WxAccountMgrEntity */



/**
 *  @Title: Entity
 @Description: 微信客服账号
 @author onlineGenerator
 @date 2016-12-23 12:05:50
 @version V1.0
 
 
 */
@interface WxKfAccountEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 账号
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 密码
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * 公众号标识
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 昵称
 *
 *
 */
@property (nonatomic, copy) NSString *nickName;
/**
 * 工号
 *
 *
 */
@property (nonatomic, copy) NSString *workNum;
/**
 * 头像
 *
 *
 */
@property (nonatomic, copy) NSString *headImgWxUrl;
/**
 * 头像媒体标识
 *
 *
 */
@property (nonatomic, copy) NSString *headImgMediaId;
/**
 * 头像本地地址
 *
 *
 */
@property (nonatomic, copy) NSString *headImgLocalUrl;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface WxKfAccountEntity */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface WxMediaEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 文件名称
 *
 *
 */
@property (nonatomic, copy) NSString *fileName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fileRawName;
/**
 * 模板名称
 *
 *
 */
@property (nonatomic, copy) NSString *templateName;
/**
 * 描述
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * 媒体文件标识
 *
 *
 */
@property (nonatomic, copy) NSString *mediaId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *realPath;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *mediaUrl;
@end /* interface WxMediaEntity */



/**
 * (no documentation provided)
 */
@interface IdEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface IdEntity */



/**
 *  后台向前台返回JSON，用于easyui的datagrid
 
 @author
 
 
 */
@interface ComboBox : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *text;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL selected;
@end /* interface ComboBox */



/**
 *  统计报表模型
 
 @author 张代浩
 
 
 */
@interface Highchart : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * (no documentation provided)
 * @see NSObject
 *
 */
@property (nonatomic, strong) NSArray<NSObject> *data;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *type;
@end /* interface Highchart */



/**
 *  $.ajax后需要接受的JSON
 
 @author
 
 
 */
@interface ValidForm : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *info;
@end /* interface ValidForm */



/**
 *  @Title: Entity
 @Description: 自动生成表的列属性
 @author jueyue
 @date 2013-06-30 11:37:32
 @version V1.0
 
 
 */
@interface CgFormFieldEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fieldName;
/**
 * 方法: 取得TablePropertyEntity
 *
 *
 */
@property (nonatomic, strong) CgFormHeadEntity *table;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger length;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger pointLength;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isNull;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isShow;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *showType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isQuery;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *queryMode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *content;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, assign) NSInteger orderNum;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isKey;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger fieldLength;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fieldHref;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fieldValidType;
/**
 * 字典Code
 *
 *
 */
@property (nonatomic, copy) NSString *dictField;
/**
 * 字典Table
 *
 *
 */
@property (nonatomic, copy) NSString *dictTable;
/**
 * 主表名称
 *
 *
 */
@property (nonatomic, copy) NSString *mainTable;
/**
 * 主表名称
 *
 *
 */
@property (nonatomic, copy) NSString *mainField;
/**
 * 主表名称
 *
 *
 */
@property (nonatomic, copy) NSString *oldFieldName;
/**
 * 是否在列表上显示
 *
 *
 */
@property (nonatomic, copy) NSString *isShowList;
/**
 * 字典文本
 *
 *
 */
@property (nonatomic, copy) NSString *dictText;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fieldDefault;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *extendJson;
@end /* interface CgFormFieldEntity */



/**
 *  @Title: Entity
 @Description: 索引表
 @author onlineGenerator
 @date 2016-06-09 20:39:52
 @version V1.0
 
 
 */
@interface CgFormIndexEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *indexName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *indexField;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *indexType;
/**
 * 方法: 取得TablePropertyEntity
 *
 *
 */
@property (nonatomic, strong) CgFormHeadEntity *table;
@end /* interface CgFormIndexEntity */



/**
 *  @Title: Entity
 @Description: 商品资料
 @author onlineGenerator
 @date 2016-06-01 21:16:32
 @version V1.0
 
 
 */
@interface GoodsEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *bpmStatus;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fullName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *outsideCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *manufacturersNo;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *supplier;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productUnit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productOwner;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brand;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *annual;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *season;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *seriesName;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double sizeLength;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double sizeWidth;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double sizeHeight;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double sizeVolume;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *timeToMarket;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceCost;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceDrop;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceStandardSell;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceStandardBid;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceTrade;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double priceProxy;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double pricePlatform;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *gift;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productVirtual;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productCost;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pointPack;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pointSell;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productUniquenessCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *batchManage;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productSingleCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *expirationDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *supplyOfMaterialRound;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *safetyInventory;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *internationalCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productState;
@end /* interface GoodsEntity */



/**
 * (no documentation provided)
 */
@interface FileMeta : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fileName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fileSize;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fileType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *bytes;
@end /* interface FileMeta */



/**
 *  $.ajax后需要接受的JSON
 
 @author
 
 
 */
@interface TableJson : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *msg;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL success;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger tableType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSObject *tableData;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSString *subTableDate;
@end /* interface TableJson */



/**
 *  @Title: Entity
 @Description: 自动生成表属性
 @author jueyue
 @date 2013-06-30 11:36:53
 @version V1.0
 
 
 */
@interface CgFormHeadEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *tableName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isTree;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isPagination;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isDbSynch;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isCheckbox;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *querymode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *content;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * (no documentation provided)
 * @see CgFormFieldEntity
 *
 */
@property (nonatomic, strong) NSArray<CgFormFieldEntity> *columns;
/**
 * (no documentation provided)
 * @see CgFormIndexEntity
 *
 */
@property (nonatomic, strong) NSArray<CgFormIndexEntity> *indexes;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *jformVersion;
/**
 * 方法: 取得Integer 1-单表,2-主表,3-从表
 *
 *
 */
@property (nonatomic, assign) NSInteger jformType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *jformPkType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *jformPkSequence;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *subTableStr;
/**
 * 方法: 取得Integer 0：一对多 1：一对一
 *
 *
 */
@property (nonatomic, assign) NSInteger relationType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger tabOrder;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *treeParentIdFieldName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *treeIdFieldname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *treeFieldname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *jformCategory;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *formTemplate;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *formTemplateMobile;
@end /* interface CgFormHeadEntity */



/**
 * (no documentation provided)
 */
@interface AjaxJson : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSString *attributes;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSObject *obj;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL success;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *msg;
@end /* interface AjaxJson */



/**
 * (no documentation provided)
 */
@interface TreeGrid : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *functionType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *order;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operations;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSString *attributes;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *parentText;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *src;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *note;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *text;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *parentId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSString *fieldMap;
@end /* interface TreeGrid */



/**
 * (no documentation provided)
 */
@interface ComboTree : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *text;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL checked;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSString *attributes;
/**
 * (no documentation provided)
 * @see ComboTree
 *
 */
@property (nonatomic, strong) NSArray<ComboTree> *children;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *iconCls;
@end /* interface ComboTree */



/**
 *  $.ajax后需要接受的JSON
 
 @author
 
 
 */
//@interface AjaxJson : JSONModel
///**
// * (no documentation provided)
// *
// *
// */
//@property (nonatomic, strong) NSString *attributes;
///**
// * (no documentation provided)
// *
// *
// */
//@property (nonatomic, copy) NSString *msg;
///**
// * (no documentation provided)
// *
// *
// */
//@property (nonatomic, strong) NSObject *obj;
///**
// * (no documentation provided)
// *
// *
// */
//@property (nonatomic, assign) BOOL success;
//@end /* interface AjaxJson */



/**
 *  @Title: Entity
 @Description: 用户标签
 @author onlineGenerator
 @date 2016-12-26 12:07:47
 @version V1.0
 
 
 */
@interface WxTagEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创��人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 公众号标识
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 标签名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 标签标识
 *
 *
 */
@property (nonatomic, assign) NSInteger tagId;
/**
 * 粉丝数
 *
 *
 */
@property (nonatomic, assign) NSInteger userCount;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface WxTagEntity */



/**
 *  @Title: Entity
 @Description: 微信用户
 @author onlineGenerator
 @date 2016-11-29 13:23:21
 @version V1.0
 
 
 */
@interface WxFansEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 公众号标识
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 用户的标识
 *
 *
 */
@property (nonatomic, copy) NSString *openid;
/**
 * 昵称
 *
 *
 */
@property (nonatomic, copy) NSString *nickname;
/**
 * 性别
 *
 *
 */
@property (nonatomic, copy) NSString *sex;
/**
 * 城市
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 国家
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 省份
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 语言
 *
 *
 */
@property (nonatomic, copy) NSString *language;
/**
 * 头像
 *
 *
 */
@property (nonatomic, copy) NSString *headimgurl;
/**
 * 用户关注时间
 *
 *
 */
@property (nonatomic, assign) long long subscribeTime;
/**
 * unionid
 *
 *
 */
@property (nonatomic, copy) NSString *unionid;
/**
 * 粉丝的备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 用户所在的分组ID
 *
 *
 */
@property (nonatomic, copy) NSString *groupid;
/**
 * 是否关注, Y or N
 *
 *
 */
@property (nonatomic, copy) NSString *subscribe;
@end /* interface WxFansEntity */



/**
 *  @Title: Entity
 @Description: 非油券
 @author onlineGenerator
 @date 2016-11-30 13:28:57
 @version V1.0
 
 
 */
@interface OtherTicketEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 券号
 *
 *
 */
@property (nonatomic, copy) NSString *ticketNumber;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
/**
 * 实际抵扣金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realPayTotal;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 所属会员
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 所属会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 订单单号
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 有效期始
 *
 *
 */
@property (nonatomic, copy) NSString *startDate;
/**
 * 有效期止
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 * 使用说明
 *
 *
 */
@property (nonatomic, copy) NSString *remak;
/**
 * 发券时间
 *
 *
 */
@property (nonatomic, copy) NSString *distributeDate;
@end /* interface OtherTicketEntity */



/**
 *  @Title: Entity
 @Description: 发票
 @author onlineGenerator
 @date 2016-12-14 13:52:13
 @version V1.0
 
 
 */
@interface InvoiceEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 会员id
 *
 *
 */
@property (nonatomic, copy) NSString *memberId;
/**
 * 会员名称
 *
 *
 */
@property (nonatomic, copy) NSString *memberName;
/**
 * 发票编号
 *
 *
 */
@property (nonatomic, copy) NSString *invoiceNumber;
/**
 * 发票类型
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 发票抬头
 *
 *
 */
@property (nonatomic, copy) NSString *title;
/**
 * 邮寄地址
 *
 *
 */
@property (nonatomic, copy) NSString *deliveryAddress;
/**
 * 收件人
 *
 *
 */
@property (nonatomic, copy) NSString *receiver;
/**
 * 电话
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * 发票状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *total;
@end /* interface InvoiceEntity */



/**
 *
 @Title: Entity
 @Description: 代管卡
 @author onlineGenerator
 @date 2017-01-05 14:29:16
 @version V1.0
 
 
 */
@interface DelegateCardEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 卡号
 *
 *
 */
@property (nonatomic, copy) NSString *cardNumber;
/**
 * 所属油站id
 *
 *
 */
@property (nonatomic, copy) NSString *stationId;
/**
 * 所属油站名称
 *
 *
 */
@property (nonatomic, copy) NSString *stationName;
/**
 * 余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *balance;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface DelegateCardEntity */



/**
 *  @Title: Entity
 @Description: 提现申请单
 @author onlineGenerator
 @date 2017-01-22 09:48:08
 @version V1.0
 
 
 */
@interface DrawCashBillEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 申请人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *applicantName;
/**
 * 申请人id
 *
 *
 */
@property (nonatomic, copy) NSString *applicantId;
/**
 * 提现工分数量
 *
 *
 */
@property (nonatomic, strong) NSNumber *workpoint;
/**
 * 提现金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *cash;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 审批人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *approverName;
/**
 * 审批人id
 *
 *
 */
@property (nonatomic, copy) NSString *approverId;
/**
 * 复核人姓名
 *
 *
 */
@property (nonatomic, copy) NSString *checkerName;
/**
 * 复核人id
 *
 *
 */
@property (nonatomic, copy) NSString *checkerId;
/**
 * 拒绝理由
 *
 *
 */
@property (nonatomic, copy) NSString *cause;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 结束日期
 *
 *
 */
@property (nonatomic, copy) NSString *finishDate;
/**
 * 审批日期
 *
 *
 */
@property (nonatomic, copy) NSString *approveDate;
@end /* interface DrawCashBillEntity */



/**
 *  @Title: Entity
 @Description: app应用更新信息
 @author onlineGenerator
 @date 2016-08-31 09:51:09
 @version V1.0
 
 
 */
@interface TOAppversionEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得版本号
 *
 *
 */
@property (nonatomic, copy) NSString *version;
/**
 * 方法: 取得新版本下载路径
 *
 *
 */
@property (nonatomic, copy) NSString *url;
/**
 * 方法: 取得是否强制更新
 *
 *
 */
@property (nonatomic, copy) NSString *forceupdate;
/**
 * 方法: 取得app类型
 *
 *
 */
@property (nonatomic, copy) NSString *apptype;
@end /* interface TOAppversionEntity */



/**
 *  @Title: Entity
 @Description: 加油员账户
 @author onlineGenerator
 @date 2016-11-17 19:47:38
 @version V1.0
 
 
 */
@interface StationUserAcctEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得加油员标识
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 方法: 取得加油员名称
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * 方法: 取得余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *balance;
/**
 * 方法: 取得日订单数量
 *
 *
 */
@property (nonatomic, assign) NSInteger dailyBillCount;
/**
 * 方法: 取得可提现余额
 *
 *
 */
@property (nonatomic, strong) NSNumber *drawBalance;
@end /* interface StationUserAcctEntity */



/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, strong) StationUserEntity *user;
/**
 * 由当前位置定位的加油站。 <br/>
 * 如果登录时没有传LoginRequest#getLongitude() 或
 * LoginRequest#getLatitude()或无法定位将返回null。
 *
 *
 */
@property (nonatomic, strong) StationEntity *station;
/**
 * 创建订单的url，APP可以拿此值生成二维码让用户扫描直接进入下单界面
 *
 *
 */
@property (nonatomic, copy) NSString *createOrderUrl;
@end /* interface LoginResult */



/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */



/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) NSInteger code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */



/**
 *  描述：</b>AlipayGzuserinfo:关注用户; InnoDB free: 130048 kB<br>
 实体定义规则 字段不允许存在基本类型，必须都是包装类型(因为基本类型有默认值) 基本数据类型 包装类 byte Byte boolean Boolean
 short Short char Character int Integer long Long float Float double Double
 
 @author zhoujf
 @since：2016年03月25日 15时24分11秒 星期五
 @version:1.0
 
 */
@interface AlipayGzuserinfo : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *department;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *position;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *gender;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *avatar;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *subscribeStatus;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *subscribeTime;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *accountid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 支付宝登录账号
 *
 *
 */
@property (nonatomic, copy) NSString *logonid;
@end /* interface AlipayGzuserinfo */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface OrderQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see OrderEntity
 *
 */
@property (nonatomic, strong) NSArray<OrderEntity> *records;
@end /* interface OrderQueryResult */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface WithdrawQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see DrawCashBillEntity
 *
 */
@property (nonatomic, strong) NSArray<DrawCashBillEntity> *records;
@end /* interface WithdrawQueryResult */



/**
 *  JeecgDemo测试表
 
 
 */
@interface JeecgDemo : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *status;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger age;
/**
 * 方法: 取得BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *salary;
/**
 * 方法: 取得Date
 *
 *
 */
@property (nonatomic, copy) NSString *birthday;
/**
 * 方法: 取得java.sql.Timestamp
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, copy) NSString *sex;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *depId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *content;
@end /* interface JeecgDemo */



/**
 *  部门机构表
 
 @author 张代浩
 
 */
@interface TSDepart : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *TSPDepart;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * (no documentation provided)
 * @see TSDepart
 *
 */
@property (nonatomic, strong) NSArray<TSDepart> *TSDeparts;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fax;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
@end /* interface TSDepart */



/**
 *  系统用户父类表
 
 @author 张代浩
 
 */
@interface TSBaseUser : IdEntity
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *userType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *signature;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *browser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short activitiSync;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *currentDepart;
/**
 * (no documentation provided)
 * @see TSUserOrg
 *
 */
@property (nonatomic, strong) NSArray<TSUserOrg> *userOrgList;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short deleteFlag;
@end /* interface TSBaseUser */



/**
 *  用户-组织机构 实体
 <p/>
 <p>
 <b>User:</b> zhanggm
 <a href="mailto:guomingzhang2008@gmail.com">guomingzhang2008@gmail.com</a>
 </p>
 <p>
 <b>Date:</b> 2014-08-22 15:39
 </p>
 
 @author 张国明
 
 */
@interface TSUserOrg : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSUser *tsUser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *tsDepart;
@end /* interface TSUserOrg */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface OrderQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 用户名称类似于
 *
 *
 */
@property (nonatomic, copy) NSString *userNameLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billNumberLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface OrderQueryDefintion */



/**
 *  @Title: Entity
 @Description: 微信群发消息
 @author onlineGenerator
 @date 2016-12-23 15:58:53
 @version V1.0
 
 
 */
@interface WxMassBillEntity : IdEntity
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *accountId;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 消息类型
 *
 *
 */
@property (nonatomic, copy) NSString *msgType;
/**
 * 文本内容
 *
 *
 */
@property (nonatomic, copy) NSString *textMsg;
/**
 * 模板标识
 *
 *
 */
@property (nonatomic, copy) NSString *templateId;
/**
 * 模板媒体标识
 *
 *
 */
@property (nonatomic, copy) NSString *mediaId;
/**
 * 全部发送
 *
 *
 */
@property (nonatomic, copy) NSString *isToAll;
/**
 * 转载继续发送
 *
 *
 */
@property (nonatomic, copy) NSString *sendIgnoreReprint;
/**
 * 卡券标识
 *
 *
 */
@property (nonatomic, copy) NSString *cardId;
/**
 * 卡券名称
 *
 *
 */
@property (nonatomic, copy) NSString *cardName;
/**
 * 消息标识
 *
 *
 */
@property (nonatomic, copy) NSString *msgId;
/**
 * 消息的数据ID
 *
 *
 */
@property (nonatomic, copy) NSString *msgDataId;
/**
 * 发送状态
 *
 *
 */
@property (nonatomic, copy) NSString *sendStatus;
/**
 * 失败信息
 *
 *
 */
@property (nonatomic, copy) NSString *sendErrMsg;
/**
 * 粉丝数
 *
 *
 */
@property (nonatomic, assign) NSInteger totalCount;
/**
 * 过滤后粉丝数
 *
 *
 */
@property (nonatomic, assign) NSInteger filterCount;
/**
 * 成功发送数
 *
 *
 */
@property (nonatomic, assign) NSInteger sentCount;
/**
 * 失败数量
 *
 *
 */
@property (nonatomic, assign) NSInteger errorCount;
/**
 * 整体校验结果
 *
 *
 */
@property (nonatomic, copy) NSString *checkState;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 模板名称
 *
 *
 */
@property (nonatomic, copy) NSString *templateName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *userTagId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *userTagName;
@end /* interface WxMassBillEntity */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface WithdrawQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 用户名称类似于
 *
 *
 */
@property (nonatomic, copy) NSString *userNameLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billNumberLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
@end /* interface WithdrawQueryDefintion */



/**
 *  订单查询结果。
 
 @author liyang
 @since 0.1
 
 */
@interface AccountHistoryQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see StationUserAcctHisEntity
 *
 */
@property (nonatomic, strong) NSArray<StationUserAcctHisEntity> *records;
@end /* interface AccountHistoryQueryResult */



/**
 *  账户流水查询。
 
 @author liyang
 @since 0.1
 
 */
@interface AccountHistoryQueryDefintion : QueryDefinition
/**
 * 加油员Id
 *
 *
 */
@property (nonatomic, copy) NSString *userId;
/**
 * 起始时间
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
@end /* interface AccountHistoryQueryDefintion */



/**
 *  系统用户表
 
 @author 张代浩
 
 */
@interface TSUser : TSBaseUser
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *signatureFile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
@end /* interface TSUser */



/**
 *  @Title: Entity
 @Description: 油站
 @author onlineGenerator
 @date 2016-11-17 20:47:03
 @version V1.0
 
 
 */
@interface StationEntity : TSDepart
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得所属公司
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得省市
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得市区
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得区县
 *
 *
 */
@property (nonatomic, copy) NSString *county;
/**
 * 方法: 取得品牌
 *
 *
 */
@property (nonatomic, copy) NSString *brand;
/**
 * 方法: 取得经度
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * 方法: 取得纬度
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
/**
 * 方法: 取得是否合作油站
 *
 *
 */
@property (nonatomic, copy) NSString *partner;
/**
 * 方法: 取得服务
 *
 *
 */
@property (nonatomic, copy) NSString *services;
/**
 * 方法: 取得评分
 *
 *
 */
@property (nonatomic, copy) NSString *grade;
/**
 * 方法: 取得备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printerMachineCode;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *printerKey;
@end /* interface StationEntity */



/**
 *  @Title: Entity
 @Description: 油站员工
 @author onlineGenerator
 @date 2016-11-17 19:43:01
 @version V1.0
 
 
 */
@interface StationUserEntity : TSUser
/**
 * openId
 *
 *
 */
@property (nonatomic, copy) NSString *wxOpenId;
/**
 * 方法: 取得工号
 *
 *
 */
@property (nonatomic, copy) NSString *worknum;
@end /* interface StationUserEntity */


