//
//  OrderListTableViewCell.m
//  Car
//
//  Created by Javen on 2016/12/26.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "OrderListTableViewCell.h"
#import "OrderListModel.h"
@implementation OrderListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)configCellArray:(NSMutableArray *)array indexPath:(NSIndexPath *)indexPath {
  OrderListModel *model = array[indexPath.row];
  self.labelTime.text = model.payTime;
  self.labelStation.text = [NSString stringWithFormat:@"%@ - %@",model.stationName, model.stationUserName];
  self.labelOil.text = [NSString stringWithFormat:@"%@ - %@",model.gasItemName, model.oilGunName];
  self.labelBillNumber.text = model.billNumber;
  self.labelPrice.text = [CalculateHelper getMoneyStringFrom:model.realPayTotal];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
