//
//  AccountRecordTableViewCell.m
//  Car
//
//  Created by Javen on 2017/2/10.
//  Copyright © 2017年 上海勾芒信息科技. All rights reserved.
//

#import "AccountRecordTableViewCell.h"
#import "AccountStateModel.h"
@implementation AccountRecordTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)configCell:(DrawCashBillEntity *)model {
    self.labelTitle.text = model.billNumber;
    self.imgState.image = [UIImage imageNamed:[AccountStateModel stateFrom:model.state].imgName];
    self.labelTime.text = model.createDate;
    self.labelCash.text = [NSString stringWithFormat:@"%@分 (金额%@元)",
                           [CalculateHelper getMoneyStringFrom:model.workpoint],
                           [CalculateHelper getMoneyStringFrom:model.cash]];
    self.labelTransferTime.text = model.finishDate ? model.finishDate : @"__ __ __ __ —:—:—";
    
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
