//
//  HttpCilent.h
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "URL.h"
#define kHttp [HttpCilent shareCilent]

@interface HttpCilent : NSObject
+ (HttpCilent * _Nullable)shareCilent;

/**
 POST请求
 
 @param URLString url
 @param parameters 请求体
 @param complete 回调
 */
- (void)POST:(NSString * _Nonnull)URLString
  parameters:(id _Nullable)parameters
    complete:(void (^ _Nullable)(id _Nullable response, NSError * _Nullable error))complete;

/**
 GET请求

 @param URLString url
 @param parameters 请求体
 @param complete 回调
 */
- (void)GET:(NSString * _Nonnull)URLString
 parameters:(id _Nullable)parameters
   complete:(void (^ _Nullable)(id _Nullable response, NSError * _Nullable error))complete;

/**
 *  检查更新
 *
 *  @param vc            当前控制器
 */
- (void)checkUpdateOnVC:(UIViewController *)vc completeIsLatest:(void(^)(void))compelete;

@end
