//
//  UIViewController+Additions.h
//  RealEstateManagement
//
//  Created by Z on 16/7/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import <UIKit/UIKit.h>
typedef NS_ENUM(NSInteger, STORYBOARD_TYPE_) {
    STORYBOARD_TYPE_MAIN = 0,
};

/**
 *  判断不能为空并提示
 *
 *  @param obj  对象
 *  @param message 为空时提示信息
 */
#define kCanNotBeNil(obj, message)                                                                                                                                                 \
    if (obj == nil) {                                                                                                                                                              \
        [MBProgressHUD j_error:message complete:nil];                                                                                                                              \
        return;                                                                                                                                                                    \
    }                                                                                                                                                                              \
    if ([obj isKindOfClass:[NSString class]]) {                                                                                                                                    \
        NSString *string = (NSString *)obj;                                                                                                                                        \
        if ([string length] == 0) {                                                                                                                                                \
            [MBProgressHUD j_error:message complete:nil];                                                                                                                          \
            return;                                                                                                                                                                \
        }                                                                                                                                                                          \
    }                                                                                                                                                                              \
    if ([obj isKindOfClass:[NSArray class]]) {                                                                                                                                     \
        NSArray *array = (NSArray *)obj;                                                                                                                                           \
        if (array.count == 0) {                                                                                                                                                    \
            [MBProgressHUD j_error:message complete:nil];                                                                                                                          \
            return;                                                                                                                                                                \
        }                                                                                                                                                                          \
    }

#define kHasPermission(permission, break)                                                                                                                                          \
    if (!permission) {                                                                                                                                                             \
        [MBProgressHUD j_error:NO_PERMISSION_TIPS complete:nil];                                                                                                                   \
        break;                                                                                                                                                                     \
    }

@interface UIViewController (Additions)

/**
 *  从不同的storyBoard文件中获取控制器
 *
 *  @param type       storyBoard类型
 *  @param identifier 标识
 *
 *  @return 对应控制器
 */
- (id __nonnull)storyboardType:(STORYBOARD_TYPE_)type identifier:(NSString *__nonnull)identifier;

/**
 *  从不同storyBoard获取控制器（这里storyBoard的id必须和类名一致）
 *
 *  @param type storyBoard类型
 *
 *  @return 对应控制器
 */
+ (id __nonnull)viewControllerWithStoryBoardType:(STORYBOARD_TYPE_)type;

/**
 *  判断输入的是否是符合要求的小数
 *
 *  @param textField 当前的textfield
 */
//- (BOOL)isValidDecimalInputtextField:(UITextField *)textField Range:(NSRange)range replacementString:(NSString *)string;

- (BOOL)regIsValidDecimalInputtextField:(UITextField *__nonnull)textField Range:(NSRange)range replacementString:(NSString *__nonnull)string;
/**
 *  弹出选择框
 *
 *  @param title        标题
 *  @param msg          详情
 *  @param okAction     确定 回调
 *  @param cancelAction 取消 回调
 */
- (void)alertTitle:(NSString *__nullable)title
               msg:(NSString *__nullable)msg
          okAction:(void (^__nullable)(UIAlertAction *__nullable action))okAction
      cancelAction:(void (^__nullable)(UIAlertAction *__nullable action))cancelAction;
/**
 *  根据输入的布尔值调用不同的方法
 *
 *  @param permission 权限
 *  @param yes        有权限 回调
 *  @param no         无权限 回调
 */
- (void)hasPermission:(BOOL)permission yes:(void (^__nonnull)(void))yes no:(void (^__nonnull)(void))no;

@end
