//
//  BaseListViewController.h
//  RealEstateManagement
//
//  Created by Javen on 16/9/8.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//


#import "BaseViewController.h"
#import "UITableView+Addtions.h"
#import "UIScrollView+EmptyDataSet.h"
#import "MJRefresh.h"

@interface BaseListViewController : BaseViewController<UITableViewDelegate, UITableViewDataSource, DZNEmptyDataSetSource, DZNEmptyDataSetDelegate>
@property (weak, nonatomic) IBOutlet UITableView *tableView;

@property (nonatomic, strong) NSMutableArray *arrData;

/**
 *  分页加载时记录当前页数
 */
@property (nonatomic, assign) NSInteger page;
/**
 *  分页加载一页大小
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 *  启用分页加载模式，还需要手动调用httpRequest
 */
- (void)paggingMode;
/**
 *  请求数据要重写这个方法，在这个方法里面请求数据，获取数据后调用showData方法，展示获取到的数据
 */
- (void)httpRequest;
/**
 *  选中列表cell之后
 */
- (void)listDidSelect:(id)model;

/**
 *  刷新tableView
 */
- (void)listTableViewReloadData;
- (void)listTableViewReloadDataWithNewRecord:(NSArray *)newRecord;
/**
 *  下拉刷新
 */
- (void)refresh;
@end
