//
//  ModifyPswTableViewController.m
//  Car
//
//  Created by Javen on 2016/12/26.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//  修改密码

#import "ModifyPswTableViewController.h"
#import "HttpCilent.h"
@interface ModifyPswTableViewController ()
@property (weak, nonatomic) IBOutlet UITextField *textFieldOldPsw;

/**
 新密码
 */
@property (weak, nonatomic) IBOutlet UITextField *textFieldNewPsw;

/**
 确认密码
 */
@property (weak, nonatomic) IBOutlet UITextField *textfiledConfirmPsw;

@end

@implementation ModifyPswTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
  self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
  self.title = @"修改密码";
}
- (IBAction)actionChange:(id)sender {
  kCanNotBeNil(self.textFieldOldPsw.text, @"旧密码不能为空！");
  kCanNotBeNil(self.textFieldNewPsw.text, @"新密码不能为空！");
  if (![self.textfiledConfirmPsw.text isEqualToString:self.textFieldNewPsw.text]) {
    [MBProgressHUD j_error:@"两次输入的新密码不一致！" complete:nil];
    return;
  }
  [self httpChangePsw];
}

- (void)httpChangePsw {
  ModifyPasswordRequest *param = [[ModifyPasswordRequest alloc] init];
  param.userName = kUser.userName;
  param.oldPassword = self.textFieldOldPsw.text;
  param.fnewPassword = self.textFieldNewPsw.text;
  [MBProgressHUD j_loading:@"修改中…"];
  WS(weakSelf);
  [kHttp POST:kModifyPswUrl parameters:[param toDictionary] complete:^(id  _Nullable response, NSError * _Nullable error) {
    [MBProgressHUD j_hideLoadingView];
    if (kRsSuccess(response)) {
      [MBProgressHUD j_success:@"密码修改成功！" complete:^{
        [weakSelf.navigationController popViewControllerAnimated:YES];
      }];
    }else{
      kShowRsMsg(response);
      
    }
  }];

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    } else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
