//
//  MainViewController.m
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "MainViewController.h"
#import "HttpCilent.h"
#import "OrderListTableViewCell.h"
#import "OrderListModel.h"
#import "OrderListFilterViewController.h"
#import "OrderDetailViewController.h"
@interface MainViewController ()
@property (strong, nonatomic) OrderListFilterViewController *filterVC;
@property (strong, nonatomic) OrderQueryDefintion *param;
@end

@implementation MainViewController

- (void)viewDidLoad {
  [super viewDidLoad];
  [self httpRequest];
}

- (void)viewWillAppear:(BOOL)animated {
  [super viewWillAppear:animated];
  kGlobal.mainVC = self;
}

- (void)httpRequest {
  CLog(@">>>>>>>>%p",self.navigationController);
  NSDictionary *param = [self.param toDictionary];
  [MBProgressHUD j_loading:@"加载中…"];
  WS(weakSelf);
  [kHttp POST:kOrderQueryUrl parameters:param complete:^(id  _Nullable response, NSError * _Nullable error) {
    [MBProgressHUD j_hideLoadingView];
    
    if (kRsSuccess(response)) {
      for (NSDictionary *dict in response[@"data"][@"records"]) {
        OrderListModel *model = [[OrderListModel alloc] initWithDictionary:dict error:nil];
        [weakSelf.arrData addObject:model];
      }
      [weakSelf listTableViewReloadData];
      
    }else{
      kShowRsMsg(response);
      [weakSelf.tableView j_endRefresh];
      if (self.page > 0) {
        self.page--;
      }
    }
    
  }];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
  return 166;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
  return self.arrData.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
  OrderListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"OrderListTableViewCell" forIndexPath:indexPath];
  [cell configCellArray:self.arrData indexPath:indexPath];
  return cell;
}

- (void)listDidSelect:(id)model {
  OrderDetailViewController *detailVC = [OrderDetailViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
  detailVC.model = model;
  [self.navigationController pushViewController:detailVC animated:YES];
}

#pragma mark - actions
- (IBAction)actionLeft:(UIBarButtonItem *)sender {
  if (kGlobal.sideSlipVC.isShowLeft) {
    [kGlobal.sideSlipVC showMainView];
  }else{
    [kGlobal.sideSlipVC showLeftView];
  }
}

- (IBAction)actionRight:(id)sender {
  if (self.filterVC.isOpen) {
    [self.filterVC hideFilterView];
  }else{
    self.filterVC.view.frame = self.view.bounds;
    [self.view addSubview:self.filterVC.view];
    [self.filterVC showFilterView];
  }
}

- (void)showShadow {
  self.shadow.hidden = NO;
}

- (void)hideShadow {
  self.shadow.hidden = YES;
}

#pragma mark - lazy
- (OrderListFilterViewController *)filterVC {
  if (!_filterVC) {
    _filterVC = [OrderListFilterViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
    _filterVC.param = self.param;
    WS(weakSelf);
    [_filterVC setBlockSubmit:^{
      [weakSelf.tableView.mj_header beginRefreshing];
    }];
    [self addChildViewController:_filterVC];
  }
  return _filterVC;
}

- (OrderQueryDefintion *)param {
  if (!_param) {
    _param = [[OrderQueryDefintion alloc] init];
    QueryOrder *order = [[QueryOrder alloc] init];
    order.field = @"payTime";
    order.direction = @"desc";
    _param.orders = @[order];
    _param.userId = kUser.fid;
    _param.state = @"paid";
  }
  return _param;
}

- (UIView *)shadow {
  if (!_shadow) {
    _shadow = [[UIView alloc] initWithFrame:self.view.bounds];
    _shadow.backgroundColor = [UIColor colorWithWhite:0.3 alpha:0.3];
    [self.view addSubview:_shadow];
    _shadow.hidden = YES;
    _shadow.tag = 11112222;
  }
  return _shadow;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
