//
//  ScanViewController.m
//  Car
//
//  Created by Javen on 2016/12/27.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "ScanViewController.h"
#import "CardViewController.h"
@interface ScanViewController ()
@property (strong, nonatomic) UIButton *btnGoInput;
@end

@implementation ScanViewController

- (void)viewDidLoad {
  [super viewDidLoad];
  self.title = @"条形码";
  
  // Do any additional setup after loading the view.
}

- (void)viewDidAppear:(BOOL)animated {
  [super viewDidAppear:animated];
  [self btnGoInput];
}

- (UIButton *)btnGoInput {
  if (!_btnGoInput) {
    _btnGoInput = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnGoInput.frame = CGRectMake(0, kHeight - 200, 120, 48);
    _btnGoInput.backgroundColor = [UIColor grayColor];
    [_btnGoInput setTitle:@"手工输入" forState:UIControlStateNormal];
    [_btnGoInput setTitleColor:[UIColor colorWithRed:0.89 green:0.44 blue:0.23 alpha:1.00] forState:UIControlStateNormal];
    _btnGoInput.layer.cornerRadius = 24;
    _btnGoInput.centerX = self.view.centerX;
    [_btnGoInput addTarget:self action:@selector(actionGoInput) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_btnGoInput];
  }
  return _btnGoInput;
}


/**
 跳转到手工输入界面
 */
- (void)actionGoInput {
  [self goCardVCWithNumber:nil];
}

- (void)goCardVCWithNumber:(NSString *)number {
  CardViewController *cardVC = [CardViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
  cardVC.cardNumber = number;
  [kGlobal.mainNaVC pushViewController:cardVC animated:YES];
  
}

#pragma mark -实现类继承该方法，作出对应处理
- (void)scanResultWithArray:(NSArray<LBXScanResult *> *)array {

  if (array.count < 1) {
   

    return;
  }

  //经测试，可以同时识别2个二维码，不能同时识别二维码和条形码
  for (LBXScanResult *result in array) {

    NSLog(@"scanResult:%@", result.strScanned);
  }

  LBXScanResult *scanResult = array[0];

  NSString *strResult = scanResult.strScanned;

  self.scanImage = scanResult.imgScanned;

  if (!strResult) {


    return;
  }

  //震动提醒
  [LBXScanWrapper systemVibrate];
  //声音提醒
  [LBXScanWrapper systemSound];
  [self goCardVCWithNumber:strResult];

}

- (void)didReceiveMemoryWarning {
  [super didReceiveMemoryWarning];
  // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little
preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
