//
//  WWSideslipViewController.m
//  WWSideslipViewControllerSample
//
//  Created by 王维 on 14-8-26.
//  Copyright (c) 2014年 wangwei. All rights reserved.
//

#import "WWSideslipViewController.h"
@interface WWSideslipViewController ()<UIGestureRecognizerDelegate>

@end

@implementation WWSideslipViewController
@synthesize speedf, sideslipTapGes;
- (id)initWithNibName:(NSString *)nibNameOrNil
               bundle:(NSBundle *)nibBundleOrNil {
  self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
  if (self) {
    // Custom initialization
  }
  return self;
}

- (void)viewDidLoad {
  [super viewDidLoad];
  // Do any additional setup after loading the view.

  //[self.view addSubview:mainControl.view];
}

- (void)didReceiveMemoryWarning {
  [super didReceiveMemoryWarning];
  // Dispose of any resources that can be recreated.
}

- (instancetype)initWithLeftView:(UIViewController *)LeftView
                     andMainView:(UIViewController *)MainView
                    andRightView:(UIViewController *)RighView
              andBackgroundImage:(UIImage *)image;
{
  if (self) {
    speedf = 0.5;

    leftControl = LeftView;
    mainControl = MainView;
    righControl = RighView;

    UIImageView *imgview =
        [[UIImageView alloc] initWithFrame:[UIScreen mainScreen].bounds];
    [imgview setImage:image];
    [self.view addSubview:imgview];

    //滑动手势
    UIPanGestureRecognizer *pan =
        [[UIPanGestureRecognizer alloc] initWithTarget:self
                                                action:@selector(handlePan:)];
    [mainControl.view addGestureRecognizer:pan];

    //单击手势
    sideslipTapGes =
        [[UITapGestureRecognizer alloc] initWithTarget:self
                                                action:@selector(handeTap:)];
    sideslipTapGes.delegate = self;
    [sideslipTapGes setNumberOfTapsRequired:1];

    [mainControl.view addGestureRecognizer:sideslipTapGes];

    leftControl.view.hidden = YES;
    righControl.view.hidden = YES;

    [self.view addSubview:leftControl.view];
    [self.view addSubview:righControl.view];

    [self.view addSubview:mainControl.view];
  }
  return self;
}

#pragma mark - 滑动手势

//滑动手势
- (void)handlePan:(UIPanGestureRecognizer *)rec {
  CLog(@"----%@",NSStringFromClass([rec.view class]));
  CGPoint point = [rec translationInView:self.view];
  if (point.x < 0 && !self.isShowLeft) {
    //手势结束后修正位置
    if (rec.state == UIGestureRecognizerStateEnded) {
      if (scalef > 140 * speedf) {
        [self showLeftView];
      } else if (scalef < -140 * speedf) {
//        [self showRighView];
        [self showMainView];
      } else {
        [self showMainView];
        scalef = 0;
      }
    }
    return;
  }
  scalef = (point.x * speedf + scalef);

  //根据视图位置判断是左滑还是右边滑动
  if (rec.view.frame.origin.x >= 0) {
    rec.view.center =
        CGPointMake(rec.view.center.x + point.x * speedf, rec.view.center.y);
    rec.view.transform = CGAffineTransformScale(
        CGAffineTransformIdentity, 1 - scalef / 1000, 1 - scalef / 1000);
    [rec setTranslation:CGPointMake(0, 0) inView:self.view];

    righControl.view.hidden = YES;
    leftControl.view.hidden = NO;

  } else {
    rec.view.center =
        CGPointMake(rec.view.center.x + point.x * speedf, rec.view.center.y);
    rec.view.transform = CGAffineTransformScale(
        CGAffineTransformIdentity, 1 + scalef / 1000, 1 + scalef / 1000);
    [rec setTranslation:CGPointMake(0, 0) inView:self.view];

    righControl.view.hidden = NO;
    leftControl.view.hidden = YES;
  }

  //手势结束后修正位置
  if (rec.state == UIGestureRecognizerStateEnded) {
    if (scalef > 140 * speedf) {
      [self showLeftView];
    } else if (scalef < -140 * speedf) {
//      [self showRighView];
      [self showMainView];
    } else {
      [self showMainView];
      scalef = 0;
    }
  }
}

#pragma mark - 单击手势
- (void)handeTap:(UITapGestureRecognizer *)tap {

  if (tap.state == UIGestureRecognizerStateEnded) {
    [self showMainView];
    scalef = 0;
  }
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch  {
  // 输出点击的view的类名
  CLog(@"%@", NSStringFromClass([touch.view class]));
  // 若为UITableViewCellContentView（即点击了tableViewCell），则不截获Touch事件
  if (self.isShowLeft) {
    return YES;
  }
  return  NO;
}

#pragma mark - 修改视图位置
//恢复位置
- (void)showMainView {
  self.isShowLeft = NO;
//  [kGlobal.mainVC hideShadow];
  [UIView beginAnimations:nil context:nil];
  mainControl.view.transform =
      CGAffineTransformScale(CGAffineTransformIdentity, 1.0, 1.0);
  mainControl.view.center =
      CGPointMake([UIScreen mainScreen].bounds.size.width / 2,
                  [UIScreen mainScreen].bounds.size.height / 2);
  [UIView commitAnimations];
}

//显示左视图
- (void)showLeftView {
  self.isShowLeft = YES;
//  [kGlobal.mainVC showShadow];
  leftControl.view.hidden = NO;
  [UIView beginAnimations:nil context:nil];
  mainControl.view.transform =
      CGAffineTransformScale(CGAffineTransformIdentity, 0.8, 0.8);
  mainControl.view.center =
      CGPointMake(kWidth * 1.2, [UIScreen mainScreen].bounds.size.height / 2);
  [UIView commitAnimations];
}

//显示右视图
- (void)showRighView {
  [UIView beginAnimations:nil context:nil];
  mainControl.view.transform =
      CGAffineTransformScale(CGAffineTransformIdentity, 0.8, 0.8);
  mainControl.view.center =
      CGPointMake(-60, [UIScreen mainScreen].bounds.size.height / 2);
  [UIView commitAnimations];
}

#warning 为了界面美观，所以隐藏了状态栏。如果需要显示则去掉此代码
- (BOOL)prefersStatusBarHidden
{
    return NO; //返回NO表示要显示，返回YES将hiden
}

@end
