//
//  AppDelegate.m
//  Car
//
//  Created by Javen on 2016/12/23.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "AppDelegate.h"
#import "GuideViewController.h"
#import "UMMobClick/MobClick.h"
#import "BMKMapManager.h"
#import "JPUSHService.h"
#import "UMMobClick/MobClick.h"

#ifdef NSFoundationVersionNumber_iOS_9_x_Max
#import <UserNotifications/UserNotifications.h> // 这里是iOS10需要用到的框架
#endif
static NSString *const JPUSHAPPKEY = @"5dc63eefddc7955ac9985390"; // 极光appKey
static NSString *const channel = @"蒲公英";                    // 固定的

#ifdef DEBUG                            // 开发
static BOOL const isProduction = FALSE; // 极光FALSE为开发环境
#else // 生产
static BOOL const isProduction = TRUE; // 极光TRUE为生产环境
#endif

@interface AppDelegate ()
{
  BMKMapManager *_mapManager;
}

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
  // Override point for customization after application launch.
  if (!kGlobal.isNoFirst) {
    GuideViewController *guideVC = [GuideViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_MAIN];
    self.window.rootViewController = guideVC;
  }
  
  _mapManager = [[BMKMapManager alloc] init];
  // 如果要关注网络及授权验证事件，请设定     generalDelegate参数
  BOOL ret =
  [_mapManager start:@"bLGWFgSNdYqP4Gf1w2IlihLO" generalDelegate:nil];
  if (!ret) {
    NSLog(@"manager start failed!");
  }
  [self JPUSHConfigWithOptions:launchOptions];
  [self UMConfig];

  return YES;
}


- (void)UMConfig {
  UMConfigInstance.appKey = @"58623721a40fa342b90010f4";
  UMConfigInstance.channelId = @"蒲公英";
  UMConfigInstance.ePolicy = REALTIME;
  [MobClick setLogEnabled:YES];
  [MobClick startWithConfigure:UMConfigInstance];
}

- (void)JPUSHConfigWithOptions:(NSDictionary *)launchOptions {
  // 注册apns通知
  if ([[UIDevice currentDevice].systemVersion floatValue] >= 10.0) // iOS10
  {
#ifdef NSFoundationVersionNumber_iOS_9_x_Max
    JPUSHRegisterEntity *entity = [[JPUSHRegisterEntity alloc] init];
    entity.types = UNAuthorizationOptionAlert | UNAuthorizationOptionBadge |
    UNAuthorizationOptionSound;
    [JPUSHService registerForRemoteNotificationConfig:entity delegate:self];
#endif
  } else if ([[UIDevice currentDevice].systemVersion floatValue] >=
             8.0) // iOS8, iOS9
  {
    //可以添加自定义categories
    [JPUSHService
     registerForRemoteNotificationTypes:(UIUserNotificationTypeBadge |
                                         UIUserNotificationTypeSound |
                                         UIUserNotificationTypeAlert)
     categories:nil];
  } else // iOS7
  {
    // categories 必须为nil
    [JPUSHService
     registerForRemoteNotificationTypes:(UIRemoteNotificationTypeBadge |UIRemoteNotificationTypeSound |UIRemoteNotificationTypeAlert)
     categories:nil];
  }
  /*
   *  launchingOption 启动参数.
   *  appKey 一个JPush 应用必须的,唯一的标识.
   *  channel 发布渠道. 可选.
   *  isProduction 是否生产环境. 如果为开发状态,设置为 NO; 如果为生产状态,应改为
   * YES.
   *  advertisingIdentifier 广告标识符（IDFA） 如果不需要使用IDFA，传nil.
   * 此接口必须在 App 启动时调用, 否则 JPush SDK 将无法正常工作.
   */
  
  // 如不需要使用IDFA，advertisingIdentifier 可为nil
  // 注册极光推送
  [JPUSHService setupWithOption:launchOptions
                         appKey:JPUSHAPPKEY
                        channel:channel
               apsForProduction:isProduction
          advertisingIdentifier:nil];
  
  // 2.1.9版本新增获取registration id block接口。
  [JPUSHService
   registrationIDCompletionHandler:^(int resCode, NSString *registrationID) {
     if (resCode == 0) {
       // iOS10获取registrationID放到这里了, 可以存到缓存里,
       // 用来标识用户单独发送推送
       NSLog(@"registrationID获取成功：%@", registrationID);
       [[NSUserDefaults standardUserDefaults] setObject:registrationID
                                                 forKey:@"registrationID"];
       [[NSUserDefaults standardUserDefaults] synchronize];
     } else {
       NSLog(@"registrationID获取失败，code：%d", resCode);
     }
   }];
}

- (void)application:(UIApplication *)application
didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
  // Required - 注册 DeviceToken
  [JPUSHService registerDeviceToken:deviceToken];
}

- (void)applicationWillResignActive:(UIApplication *)application {
  // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
  // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
  // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
  // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
  // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
  // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}


- (void)applicationWillTerminate:(UIApplication *)application {
  // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}


@end
