//
//  ICRUserUtil.h
//  Cruiser
//  手机app登陆者
//  Created by Xummer on 3/29/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface ICRUserUtil : IBTObject <NSCoding, NSCopying> //归档存储


@property (copy, nonatomic) NSString *f_user_password;
@property (copy, nonatomic) NSString *f_user_loginName;//登录时填写的名称
@property (copy, nonatomic) NSString *f_user_code;//用户代码
@property (copy, nonatomic) NSString *f_user_name;//用户名称
@property (copy, nonatomic) NSString *f_user_uuid;//唯一标识

@property (copy, nonatomic) NSString *f_authenticode;//企业认证码
@property (copy, nonatomic) NSString *f_enterprise_code;//企业代码
@property (copy, nonatomic) NSString *f_enterprise_name;//企业名称
@property (copy, nonatomic) NSString *f_enterprise_uuid;//唯一标识

@property (copy, nonatomic) NSArray *f_permissions;//权限列表
//@property (copy, nonatomic) NSString *f_city;//百度地图定位的城市
@property (copy, nonatomic) NSString *f_Org_uuid;//所属组织
@property (copy, nonatomic) NSString *f_Org_code;//所属组织代码
@property (copy, nonatomic) NSString *f_Org_name;//所属组织名称
@property (assign, nonatomic) BOOL f_belongOrgIsLeaf;//所属组织是否叶子
@property (copy, nonatomic) NSString *f_belongOrgPath;//所属组织的路径
//@property (assign,nonatomic)BOOL needFresh;

// Login Data
@property (copy, nonatomic) NSString *userName;
@property (copy, nonatomic) NSString *password;
@property (copy, nonatomic) NSString *registerCode;
@property (copy, nonatomic) NSString *token;
@property (copy, nonatomic) NSNumber *bAutoLogin;

// User Data
@property (copy, nonatomic) NSString *displayName;
@property (copy, nonatomic) NSString *orgCode;
@property (copy, nonatomic) NSString *orgName;
@property (copy, nonatomic) NSNumber *currentStoreID;
@property (copy, nonatomic) NSString *uniqueID;

+ (instancetype)sharedInstance;

- (BOOL)saveArchive;

- (BOOL)isLogin;

- (void)logout;

- (NSString *)mobileID;

- (void)storageUserName:(NSString *)userName
               password:(NSString *)password
           registerCode:(NSString *)registerCode
                  token:(NSString *)token;

- (void)storageCurrentStoreID:(NSNumber *)currentStoreID;

- (void)updatePassword:(NSString *)pwd;

@end
