//
//  IBTUILabel.m
//  IBTTableViewKit
//
//  Created by Xummer on 15/1/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTUILabel.h"

@implementation IBTUILabel

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    self.backgroundColor = [UIColor clearColor];
    
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame
                         text: (NSString *)text
                         font: (UIFont *)font
                    tintColor: (UIColor *)tintColor
              backgroundColor: (UIColor *)bgColor
                textAlignment: (NSTextAlignment)textAlignment
{
    if (self =  [super initWithFrame:frame]) {
        self.text = text;
        self.font = font;
         self.textColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.tintColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.backgroundColor =  bgColor == nil ?[UIColor whiteColor] : bgColor;
        self.textAlignment = textAlignment;
    }
    return self;
}
- (instancetype)initWithtext:(NSString *)text font:(UIFont *)font tintColor:(UIColor *)tintColor backgroundColor:(UIColor *)bgColor textAlignment:(NSTextAlignment)textAlignment {
    if (self = [super init]) {
        self.textColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.tintColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.text = text;
        self.font = font;
    
        self.backgroundColor = bgColor == nil ?[UIColor whiteColor] : bgColor;
        self.textAlignment = textAlignment;
    }
    
    return self;
}

- (instancetype)initWithfont: (UIFont *)font
                   tintColor: (UIColor *)tintColor
             backgroundColor: (UIColor *)bgColor
               textAlignment: (NSTextAlignment)textAlignment {
    if (self = [super init]) {
        self.textColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.tintColor = tintColor == nil ?[UIColor blackColor] : tintColor;
        self.font = font;
      
        self.backgroundColor = bgColor == nil ?[UIColor whiteColor] : bgColor;
        self.textAlignment = textAlignment;
    }
    
    return self;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
