//
//  UserInfoShop.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoShop.h"


NSString *const kUserInfoShopName = @"name";
NSString *const kUserInfoShopUuid = @"uuid";
NSString *const kUserInfoShopCode = @"code";


@interface UserInfoShop ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoShop

@synthesize name = _name;
@synthesize uuid = _uuid;
@synthesize code = _code;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kUserInfoShopName fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kUserInfoShopUuid fromDictionary:dict];
            self.code = [self objectOrNilForKey:kUserInfoShopCode fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kUserInfoShopName];
    [mutableDict setValue:self.uuid forKey:kUserInfoShopUuid];
    [mutableDict setValue:self.code forKey:kUserInfoShopCode];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kUserInfoShopName];
    self.uuid = [aDecoder decodeObjectForKey:kUserInfoShopUuid];
    self.code = [aDecoder decodeObjectForKey:kUserInfoShopCode];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kUserInfoShopName];
    [aCoder encodeObject:_uuid forKey:kUserInfoShopUuid];
    [aCoder encodeObject:_code forKey:kUserInfoShopCode];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoShop *copy = [[UserInfoShop alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
    }
    
    return copy;
}


@end
