//
//  UserInfoPasswordControl.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoPasswordControl.h"


NSString *const kUserInfoPasswordControlCreated = @"created";
NSString *const kUserInfoPasswordControlInitPassword = @"initPassword";
NSString *const kUserInfoPasswordControlExpiry = @"expiry";


@interface UserInfoPasswordControl ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoPasswordControl

@synthesize created = _created;
@synthesize initPassword = _initPassword;
@synthesize expiry = _expiry;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.created = [[self objectOrNilForKey:kUserInfoPasswordControlCreated fromDictionary:dict] doubleValue];
            self.initPassword = [self objectOrNilForKey:kUserInfoPasswordControlInitPassword fromDictionary:dict];
            self.expiry = [[self objectOrNilForKey:kUserInfoPasswordControlExpiry fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.created] forKey:kUserInfoPasswordControlCreated];
    [mutableDict setValue:self.initPassword forKey:kUserInfoPasswordControlInitPassword];
    [mutableDict setValue:[NSNumber numberWithDouble:self.expiry] forKey:kUserInfoPasswordControlExpiry];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.created = [aDecoder decodeDoubleForKey:kUserInfoPasswordControlCreated];
    self.initPassword = [aDecoder decodeObjectForKey:kUserInfoPasswordControlInitPassword];
    self.expiry = [aDecoder decodeDoubleForKey:kUserInfoPasswordControlExpiry];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_created forKey:kUserInfoPasswordControlCreated];
    [aCoder encodeObject:_initPassword forKey:kUserInfoPasswordControlInitPassword];
    [aCoder encodeDouble:_expiry forKey:kUserInfoPasswordControlExpiry];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoPasswordControl *copy = [[UserInfoPasswordControl alloc] init];
    
    if (copy) {

        copy.created = self.created;
        copy.initPassword = [self.initPassword copyWithZone:zone];
        copy.expiry = self.expiry;
    }
    
    return copy;
}


@end
