//
//  UserInfoOwnerOrg.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoOwnerOrg.h"


NSString *const kUserInfoOwnerOrgName = @"name";
NSString *const kUserInfoOwnerOrgUuid = @"uuid";
NSString *const kUserInfoOwnerOrgCode = @"code";


@interface UserInfoOwnerOrg ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoOwnerOrg

@synthesize name = _name;
@synthesize uuid = _uuid;
@synthesize code = _code;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kUserInfoOwnerOrgName fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kUserInfoOwnerOrgUuid fromDictionary:dict];
            self.code = [self objectOrNilForKey:kUserInfoOwnerOrgCode fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kUserInfoOwnerOrgName];
    [mutableDict setValue:self.uuid forKey:kUserInfoOwnerOrgUuid];
    [mutableDict setValue:self.code forKey:kUserInfoOwnerOrgCode];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kUserInfoOwnerOrgName];
    self.uuid = [aDecoder decodeObjectForKey:kUserInfoOwnerOrgUuid];
    self.code = [aDecoder decodeObjectForKey:kUserInfoOwnerOrgCode];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kUserInfoOwnerOrgName];
    [aCoder encodeObject:_uuid forKey:kUserInfoOwnerOrgUuid];
    [aCoder encodeObject:_code forKey:kUserInfoOwnerOrgCode];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoOwnerOrg *copy = [[UserInfoOwnerOrg alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
    }
    
    return copy;
}


@end
