//
//  UserInfoLoginControl.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoLoginControl.h"


NSString *const kUserInfoLoginControlLoginIp = @"loginIp";
NSString *const kUserInfoLoginControlLoginTime = @"loginTime";
NSString *const kUserInfoLoginControlFailedTimes = @"failedTimes";


@interface UserInfoLoginControl ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoLoginControl

@synthesize loginIp = _loginIp;
@synthesize loginTime = _loginTime;
@synthesize failedTimes = _failedTimes;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.loginIp = [self objectOrNilForKey:kUserInfoLoginControlLoginIp fromDictionary:dict];
            self.loginTime = [[self objectOrNilForKey:kUserInfoLoginControlLoginTime fromDictionary:dict] doubleValue];
            self.failedTimes = [[self objectOrNilForKey:kUserInfoLoginControlFailedTimes fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.loginIp forKey:kUserInfoLoginControlLoginIp];
    [mutableDict setValue:[NSNumber numberWithDouble:self.loginTime] forKey:kUserInfoLoginControlLoginTime];
    [mutableDict setValue:[NSNumber numberWithDouble:self.failedTimes] forKey:kUserInfoLoginControlFailedTimes];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.loginIp = [aDecoder decodeObjectForKey:kUserInfoLoginControlLoginIp];
    self.loginTime = [aDecoder decodeDoubleForKey:kUserInfoLoginControlLoginTime];
    self.failedTimes = [aDecoder decodeDoubleForKey:kUserInfoLoginControlFailedTimes];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_loginIp forKey:kUserInfoLoginControlLoginIp];
    [aCoder encodeDouble:_loginTime forKey:kUserInfoLoginControlLoginTime];
    [aCoder encodeDouble:_failedTimes forKey:kUserInfoLoginControlFailedTimes];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoLoginControl *copy = [[UserInfoLoginControl alloc] init];
    
    if (copy) {

        copy.loginIp = [self.loginIp copyWithZone:zone];
        copy.loginTime = self.loginTime;
        copy.failedTimes = self.failedTimes;
    }
    
    return copy;
}


@end
