//
//  UserInfoLastModifyInfo.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoLastModifyInfo.h"


NSString *const kUserInfoLastModifyInfoOperator = @"operator";
NSString *const kUserInfoLastModifyInfoTime = @"time";


@interface UserInfoLastModifyInfo ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoLastModifyInfo

@synthesize operator = _operator;
@synthesize time = _time;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operator = [self objectOrNilForKey:kUserInfoLastModifyInfoOperator fromDictionary:dict];
            self.time = [[self objectOrNilForKey:kUserInfoLastModifyInfoTime fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.operator forKey:kUserInfoLastModifyInfoOperator];
    [mutableDict setValue:[NSNumber numberWithDouble:self.time] forKey:kUserInfoLastModifyInfoTime];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operator = [aDecoder decodeObjectForKey:kUserInfoLastModifyInfoOperator];
    self.time = [aDecoder decodeDoubleForKey:kUserInfoLastModifyInfoTime];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operator forKey:kUserInfoLastModifyInfoOperator];
    [aCoder encodeDouble:_time forKey:kUserInfoLastModifyInfoTime];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoLastModifyInfo *copy = [[UserInfoLastModifyInfo alloc] init];
    
    if (copy) {

        copy.operator = [self.operator copyWithZone:zone];
        copy.time = self.time;
    }
    
    return copy;
}


@end
