//
//  UserInfoCertificate.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoCertificate.h"


NSString *const kUserInfoCertificateBankCards = @"bankCards";
NSString *const kUserInfoCertificateIdValidated = @"idValidated";
NSString *const kUserInfoCertificateCode = @"code";
NSString *const kUserInfoCertificateUuid = @"uuid";
NSString *const kUserInfoCertificateTrueName = @"trueName";
NSString *const kUserInfoCertificateGood = @"good";
NSString *const kUserInfoCertificateName = @"name";


@interface UserInfoCertificate ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoCertificate

@synthesize bankCards = _bankCards;
@synthesize idValidated = _idValidated;
@synthesize code = _code;
@synthesize uuid = _uuid;
@synthesize trueName = _trueName;
@synthesize good = _good;
@synthesize name = _name;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.bankCards = [self objectOrNilForKey:kUserInfoCertificateBankCards fromDictionary:dict];
            self.idValidated = [[self objectOrNilForKey:kUserInfoCertificateIdValidated fromDictionary:dict] boolValue];
            self.code = [self objectOrNilForKey:kUserInfoCertificateCode fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kUserInfoCertificateUuid fromDictionary:dict];
            self.trueName = [self objectOrNilForKey:kUserInfoCertificateTrueName fromDictionary:dict];
            self.good = [self objectOrNilForKey:kUserInfoCertificateGood fromDictionary:dict];
            self.name = [self objectOrNilForKey:kUserInfoCertificateName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    NSMutableArray *tempArrayForBankCards = [NSMutableArray array];
    for (NSObject *subArrayObject in self.bankCards) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForBankCards addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForBankCards addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForBankCards] forKey:kUserInfoCertificateBankCards];
    [mutableDict setValue:[NSNumber numberWithBool:self.idValidated] forKey:kUserInfoCertificateIdValidated];
    [mutableDict setValue:self.code forKey:kUserInfoCertificateCode];
    [mutableDict setValue:self.uuid forKey:kUserInfoCertificateUuid];
    [mutableDict setValue:self.trueName forKey:kUserInfoCertificateTrueName];
    [mutableDict setValue:self.good forKey:kUserInfoCertificateGood];
    [mutableDict setValue:self.name forKey:kUserInfoCertificateName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.bankCards = [aDecoder decodeObjectForKey:kUserInfoCertificateBankCards];
    self.idValidated = [aDecoder decodeBoolForKey:kUserInfoCertificateIdValidated];
    self.code = [aDecoder decodeObjectForKey:kUserInfoCertificateCode];
    self.uuid = [aDecoder decodeObjectForKey:kUserInfoCertificateUuid];
    self.trueName = [aDecoder decodeObjectForKey:kUserInfoCertificateTrueName];
    self.good = [aDecoder decodeObjectForKey:kUserInfoCertificateGood];
    self.name = [aDecoder decodeObjectForKey:kUserInfoCertificateName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_bankCards forKey:kUserInfoCertificateBankCards];
    [aCoder encodeBool:_idValidated forKey:kUserInfoCertificateIdValidated];
    [aCoder encodeObject:_code forKey:kUserInfoCertificateCode];
    [aCoder encodeObject:_uuid forKey:kUserInfoCertificateUuid];
    [aCoder encodeObject:_trueName forKey:kUserInfoCertificateTrueName];
    [aCoder encodeObject:_good forKey:kUserInfoCertificateGood];
    [aCoder encodeObject:_name forKey:kUserInfoCertificateName];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoCertificate *copy = [[UserInfoCertificate alloc] init];
    
    if (copy) {

        copy.bankCards = [self.bankCards copyWithZone:zone];
        copy.idValidated = self.idValidated;
        copy.code = [self.code copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.trueName = [self.trueName copyWithZone:zone];
        copy.good = [self.good copyWithZone:zone];
        copy.name = [self.name copyWithZone:zone];
    }
    
    return copy;
}


@end
