//
//  UserInfoBaseClass.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "UserInfoBaseClass.h"
#import "UserInfoOwnerOrg.h"
#import "UserInfoLastModifyInfo.h"
#import "UserInfoCertificate.h"
#import "UserInfoPasswordControl.h"
#import "UserInfoShop.h"
#import "UserInfoCreateInfo.h"
#import "UserInfoLoginControl.h"


NSString *const kUserInfoBaseClassBirthday = @"birthday";
NSString *const kUserInfoBaseClassPortrait = @"portrait";
NSString *const kUserInfoBaseClassOwnerOrg = @"ownerOrg";
NSString *const kUserInfoBaseClassCode = @"code";
NSString *const kUserInfoBaseClassTelephone = @"telephone";
NSString *const kUserInfoBaseClassMobilephone = @"mobilephone";
NSString *const kUserInfoBaseClassUuid = @"uuid";
NSString *const kUserInfoBaseClassLastModifyInfo = @"lastModifyInfo";
NSString *const kUserInfoBaseClassSocialContact = @"socialContact";
NSString *const kUserInfoBaseClassCertificate = @"certificate";
NSString *const kUserInfoBaseClassVersion = @"version";
NSString *const kUserInfoBaseClassName = @"name";
NSString *const kUserInfoBaseClassInvitationCode = @"invitationCode";
NSString *const kUserInfoBaseClassState = @"state";
NSString *const kUserInfoBaseClassDomain = @"domain";
NSString *const kUserInfoBaseClassPasswordControl = @"passwordControl";
NSString *const kUserInfoBaseClassGender = @"gender";
NSString *const kUserInfoBaseClassRoles = @"roles";
NSString *const kUserInfoBaseClassPostalAddresses = @"postalAddresses";
NSString *const kUserInfoBaseClassIdCard = @"idCard";
NSString *const kUserInfoBaseClassReferrer = @"referrer";
NSString *const kUserInfoBaseClassShop = @"shop";
NSString *const kUserInfoBaseClassCreateInfo = @"createInfo";
NSString *const kUserInfoBaseClassOrder = @"order";
NSString *const kUserInfoBaseClassLoginControl = @"loginControl";
NSString *const kUserInfoBaseClassDescription = @"description";


@interface UserInfoBaseClass ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation UserInfoBaseClass

@synthesize birthday = _birthday;
@synthesize portrait = _portrait;
@synthesize ownerOrg = _ownerOrg;
@synthesize code = _code;
@synthesize telephone = _telephone;
@synthesize mobilephone = _mobilephone;
@synthesize uuid = _uuid;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize socialContact = _socialContact;
@synthesize certificate = _certificate;
@synthesize version = _version;
@synthesize name = _name;
@synthesize invitationCode = _invitationCode;
@synthesize state = _state;
@synthesize domain = _domain;
@synthesize passwordControl = _passwordControl;
@synthesize gender = _gender;
@synthesize roles = _roles;
@synthesize postalAddresses = _postalAddresses;
@synthesize idCard = _idCard;
@synthesize referrer = _referrer;
@synthesize shop = _shop;
@synthesize createInfo = _createInfo;
@synthesize order = _order;
@synthesize loginControl = _loginControl;
@synthesize internalBaseClassDescription = _internalBaseClassDescription;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.birthday = [self objectOrNilForKey:kUserInfoBaseClassBirthday fromDictionary:dict];
            self.portrait = [self objectOrNilForKey:kUserInfoBaseClassPortrait fromDictionary:dict];
            self.ownerOrg = [UserInfoOwnerOrg modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassOwnerOrg]];
            self.code = [self objectOrNilForKey:kUserInfoBaseClassCode fromDictionary:dict];
            self.telephone = [self objectOrNilForKey:kUserInfoBaseClassTelephone fromDictionary:dict];
            self.mobilephone = [self objectOrNilForKey:kUserInfoBaseClassMobilephone fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kUserInfoBaseClassUuid fromDictionary:dict];
            self.lastModifyInfo = [UserInfoLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassLastModifyInfo]];
            self.socialContact = [self objectOrNilForKey:kUserInfoBaseClassSocialContact fromDictionary:dict];
            self.certificate = [UserInfoCertificate modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassCertificate]];
            self.version = [[self objectOrNilForKey:kUserInfoBaseClassVersion fromDictionary:dict] doubleValue];
            self.name = [self objectOrNilForKey:kUserInfoBaseClassName fromDictionary:dict];
            self.invitationCode = [self objectOrNilForKey:kUserInfoBaseClassInvitationCode fromDictionary:dict];
            self.state = [self objectOrNilForKey:kUserInfoBaseClassState fromDictionary:dict];
            self.domain = [self objectOrNilForKey:kUserInfoBaseClassDomain fromDictionary:dict];
            self.passwordControl = [UserInfoPasswordControl modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassPasswordControl]];
            self.gender = [self objectOrNilForKey:kUserInfoBaseClassGender fromDictionary:dict];
            self.roles = [self objectOrNilForKey:kUserInfoBaseClassRoles fromDictionary:dict];
            self.postalAddresses = [self objectOrNilForKey:kUserInfoBaseClassPostalAddresses fromDictionary:dict];
            self.idCard = [self objectOrNilForKey:kUserInfoBaseClassIdCard fromDictionary:dict];
            self.referrer = [self objectOrNilForKey:kUserInfoBaseClassReferrer fromDictionary:dict];
            self.shop = [UserInfoShop modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassShop]];
            self.createInfo = [UserInfoCreateInfo modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassCreateInfo]];
            self.order = [[self objectOrNilForKey:kUserInfoBaseClassOrder fromDictionary:dict] doubleValue];
            self.loginControl = [UserInfoLoginControl modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassLoginControl]];
            self.internalBaseClassDescription = [self objectOrNilForKey:kUserInfoBaseClassDescription fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.birthday forKey:kUserInfoBaseClassBirthday];
    [mutableDict setValue:self.portrait forKey:kUserInfoBaseClassPortrait];
    [mutableDict setValue:[self.ownerOrg dictionaryRepresentation] forKey:kUserInfoBaseClassOwnerOrg];
    [mutableDict setValue:self.code forKey:kUserInfoBaseClassCode];
    [mutableDict setValue:self.telephone forKey:kUserInfoBaseClassTelephone];
    [mutableDict setValue:self.mobilephone forKey:kUserInfoBaseClassMobilephone];
    [mutableDict setValue:self.uuid forKey:kUserInfoBaseClassUuid];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kUserInfoBaseClassLastModifyInfo];
    [mutableDict setValue:self.socialContact forKey:kUserInfoBaseClassSocialContact];
    [mutableDict setValue:[self.certificate dictionaryRepresentation] forKey:kUserInfoBaseClassCertificate];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kUserInfoBaseClassVersion];
    [mutableDict setValue:self.name forKey:kUserInfoBaseClassName];
    [mutableDict setValue:self.invitationCode forKey:kUserInfoBaseClassInvitationCode];
    [mutableDict setValue:self.state forKey:kUserInfoBaseClassState];
    [mutableDict setValue:self.domain forKey:kUserInfoBaseClassDomain];
    [mutableDict setValue:[self.passwordControl dictionaryRepresentation] forKey:kUserInfoBaseClassPasswordControl];
    [mutableDict setValue:self.gender forKey:kUserInfoBaseClassGender];
    NSMutableArray *tempArrayForRoles = [NSMutableArray array];
    for (NSObject *subArrayObject in self.roles) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForRoles addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForRoles addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForRoles] forKey:kUserInfoBaseClassRoles];
    [mutableDict setValue:self.postalAddresses forKey:kUserInfoBaseClassPostalAddresses];
    [mutableDict setValue:self.idCard forKey:kUserInfoBaseClassIdCard];
    [mutableDict setValue:self.referrer forKey:kUserInfoBaseClassReferrer];
    [mutableDict setValue:[self.shop dictionaryRepresentation] forKey:kUserInfoBaseClassShop];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kUserInfoBaseClassCreateInfo];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kUserInfoBaseClassOrder];
    [mutableDict setValue:[self.loginControl dictionaryRepresentation] forKey:kUserInfoBaseClassLoginControl];
    [mutableDict setValue:self.internalBaseClassDescription forKey:kUserInfoBaseClassDescription];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (void)UserInfoWithDictionary:(NSDictionary *)dict
{
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
        self.birthday = [self objectOrNilForKey:kUserInfoBaseClassBirthday fromDictionary:dict];
        self.portrait = [self objectOrNilForKey:kUserInfoBaseClassPortrait fromDictionary:dict];
        self.ownerOrg = [UserInfoOwnerOrg modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassOwnerOrg]];
        self.code = [self objectOrNilForKey:kUserInfoBaseClassCode fromDictionary:dict];
        self.telephone = [self objectOrNilForKey:kUserInfoBaseClassTelephone fromDictionary:dict];
        self.mobilephone = [self objectOrNilForKey:kUserInfoBaseClassMobilephone fromDictionary:dict];
        self.uuid = [self objectOrNilForKey:kUserInfoBaseClassUuid fromDictionary:dict];
        self.lastModifyInfo = [UserInfoLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassLastModifyInfo]];
        self.socialContact = [self objectOrNilForKey:kUserInfoBaseClassSocialContact fromDictionary:dict];
        self.certificate = [UserInfoCertificate modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassCertificate]];
        self.version = [[self objectOrNilForKey:kUserInfoBaseClassVersion fromDictionary:dict] doubleValue];
        self.name = [self objectOrNilForKey:kUserInfoBaseClassName fromDictionary:dict];
        self.invitationCode = [self objectOrNilForKey:kUserInfoBaseClassInvitationCode fromDictionary:dict];
        self.state = [self objectOrNilForKey:kUserInfoBaseClassState fromDictionary:dict];
        self.domain = [self objectOrNilForKey:kUserInfoBaseClassDomain fromDictionary:dict];
        self.passwordControl = [UserInfoPasswordControl modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassPasswordControl]];
        self.gender = [self objectOrNilForKey:kUserInfoBaseClassGender fromDictionary:dict];
        self.roles = [self objectOrNilForKey:kUserInfoBaseClassRoles fromDictionary:dict];
        self.postalAddresses = [self objectOrNilForKey:kUserInfoBaseClassPostalAddresses fromDictionary:dict];
        self.idCard = [self objectOrNilForKey:kUserInfoBaseClassIdCard fromDictionary:dict];
        self.referrer = [self objectOrNilForKey:kUserInfoBaseClassReferrer fromDictionary:dict];
        self.shop = [UserInfoShop modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassShop]];
        self.createInfo = [UserInfoCreateInfo modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassCreateInfo]];
        self.order = [[self objectOrNilForKey:kUserInfoBaseClassOrder fromDictionary:dict] doubleValue];
        self.loginControl = [UserInfoLoginControl modelObjectWithDictionary:[dict objectForKey:kUserInfoBaseClassLoginControl]];
        self.internalBaseClassDescription = [self objectOrNilForKey:kUserInfoBaseClassDescription fromDictionary:dict];
        
    }
        
}

- (NSString *)description
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.birthday = [aDecoder decodeObjectForKey:kUserInfoBaseClassBirthday];
    self.portrait = [aDecoder decodeObjectForKey:kUserInfoBaseClassPortrait];
    self.ownerOrg = [aDecoder decodeObjectForKey:kUserInfoBaseClassOwnerOrg];
    self.code = [aDecoder decodeObjectForKey:kUserInfoBaseClassCode];
    self.telephone = [aDecoder decodeObjectForKey:kUserInfoBaseClassTelephone];
    self.mobilephone = [aDecoder decodeObjectForKey:kUserInfoBaseClassMobilephone];
    self.uuid = [aDecoder decodeObjectForKey:kUserInfoBaseClassUuid];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kUserInfoBaseClassLastModifyInfo];
    self.socialContact = [aDecoder decodeObjectForKey:kUserInfoBaseClassSocialContact];
    self.certificate = [aDecoder decodeObjectForKey:kUserInfoBaseClassCertificate];
    self.version = [aDecoder decodeDoubleForKey:kUserInfoBaseClassVersion];
    self.name = [aDecoder decodeObjectForKey:kUserInfoBaseClassName];
    self.invitationCode = [aDecoder decodeObjectForKey:kUserInfoBaseClassInvitationCode];
    self.state = [aDecoder decodeObjectForKey:kUserInfoBaseClassState];
    self.domain = [aDecoder decodeObjectForKey:kUserInfoBaseClassDomain];
    self.passwordControl = [aDecoder decodeObjectForKey:kUserInfoBaseClassPasswordControl];
    self.gender = [aDecoder decodeObjectForKey:kUserInfoBaseClassGender];
    self.roles = [aDecoder decodeObjectForKey:kUserInfoBaseClassRoles];
    self.postalAddresses = [aDecoder decodeObjectForKey:kUserInfoBaseClassPostalAddresses];
    self.idCard = [aDecoder decodeObjectForKey:kUserInfoBaseClassIdCard];
    self.referrer = [aDecoder decodeObjectForKey:kUserInfoBaseClassReferrer];
    self.shop = [aDecoder decodeObjectForKey:kUserInfoBaseClassShop];
    self.createInfo = [aDecoder decodeObjectForKey:kUserInfoBaseClassCreateInfo];
    self.order = [aDecoder decodeDoubleForKey:kUserInfoBaseClassOrder];
    self.loginControl = [aDecoder decodeObjectForKey:kUserInfoBaseClassLoginControl];
    self.internalBaseClassDescription = [aDecoder decodeObjectForKey:kUserInfoBaseClassDescription];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_birthday forKey:kUserInfoBaseClassBirthday];
    [aCoder encodeObject:_portrait forKey:kUserInfoBaseClassPortrait];
    [aCoder encodeObject:_ownerOrg forKey:kUserInfoBaseClassOwnerOrg];
    [aCoder encodeObject:_code forKey:kUserInfoBaseClassCode];
    [aCoder encodeObject:_telephone forKey:kUserInfoBaseClassTelephone];
    [aCoder encodeObject:_mobilephone forKey:kUserInfoBaseClassMobilephone];
    [aCoder encodeObject:_uuid forKey:kUserInfoBaseClassUuid];
    [aCoder encodeObject:_lastModifyInfo forKey:kUserInfoBaseClassLastModifyInfo];
    [aCoder encodeObject:_socialContact forKey:kUserInfoBaseClassSocialContact];
    [aCoder encodeObject:_certificate forKey:kUserInfoBaseClassCertificate];
    [aCoder encodeDouble:_version forKey:kUserInfoBaseClassVersion];
    [aCoder encodeObject:_name forKey:kUserInfoBaseClassName];
    [aCoder encodeObject:_invitationCode forKey:kUserInfoBaseClassInvitationCode];
    [aCoder encodeObject:_state forKey:kUserInfoBaseClassState];
    [aCoder encodeObject:_domain forKey:kUserInfoBaseClassDomain];
    [aCoder encodeObject:_passwordControl forKey:kUserInfoBaseClassPasswordControl];
    [aCoder encodeObject:_gender forKey:kUserInfoBaseClassGender];
    [aCoder encodeObject:_roles forKey:kUserInfoBaseClassRoles];
    [aCoder encodeObject:_postalAddresses forKey:kUserInfoBaseClassPostalAddresses];
    [aCoder encodeObject:_idCard forKey:kUserInfoBaseClassIdCard];
    [aCoder encodeObject:_referrer forKey:kUserInfoBaseClassReferrer];
    [aCoder encodeObject:_shop forKey:kUserInfoBaseClassShop];
    [aCoder encodeObject:_createInfo forKey:kUserInfoBaseClassCreateInfo];
    [aCoder encodeDouble:_order forKey:kUserInfoBaseClassOrder];
    [aCoder encodeObject:_loginControl forKey:kUserInfoBaseClassLoginControl];
    [aCoder encodeObject:_internalBaseClassDescription forKey:kUserInfoBaseClassDescription];
}

- (id)copyWithZone:(NSZone *)zone
{
    UserInfoBaseClass *copy = [[UserInfoBaseClass alloc] init];
    
    if (copy) {

        copy.birthday = [self.birthday copyWithZone:zone];
        copy.portrait = [self.portrait copyWithZone:zone];
        copy.ownerOrg = [self.ownerOrg copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.telephone = [self.telephone copyWithZone:zone];
        copy.mobilephone = [self.mobilephone copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.socialContact = [self.socialContact copyWithZone:zone];
        copy.certificate = [self.certificate copyWithZone:zone];
        copy.version = self.version;
        copy.name = [self.name copyWithZone:zone];
        copy.invitationCode = [self.invitationCode copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.domain = [self.domain copyWithZone:zone];
        copy.passwordControl = [self.passwordControl copyWithZone:zone];
        copy.gender = [self.gender copyWithZone:zone];
        copy.roles = [self.roles copyWithZone:zone];
        copy.postalAddresses = [self.postalAddresses copyWithZone:zone];
        copy.idCard = [self.idCard copyWithZone:zone];
        copy.referrer = [self.referrer copyWithZone:zone];
        copy.shop = [self.shop copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.order = self.order;
        copy.loginControl = [self.loginControl copyWithZone:zone];
        copy.internalBaseClassDescription = [self.internalBaseClassDescription copyWithZone:zone];
    }
    
    return copy;
}


@end
