//
//  addCommodityRequestModel.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "addCommodityRequestModel.h"
#import "OperCtx.h"


NSString *const kaddCommodityRequestModelOperCtx = @"operCtx";
NSString *const kaddCommodityRequestModelShopUuid = @"shopUuid";
NSString *const kaddCommodityRequestModelGoodsUuid = @"goodsUuid";


@interface addCommodityRequestModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation addCommodityRequestModel

@synthesize operCtx = _operCtx;
@synthesize shopUuid = _shopUuid;
@synthesize goodsUuid = _goodsUuid;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operCtx = [OperCtx modelObjectWithDictionary:[dict objectForKey:kaddCommodityRequestModelOperCtx]];
            self.shopUuid = [self objectOrNilForKey:kaddCommodityRequestModelShopUuid fromDictionary:dict];
            self.goodsUuid = [self objectOrNilForKey:kaddCommodityRequestModelGoodsUuid fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.operCtx dictionaryRepresentation] forKey:kaddCommodityRequestModelOperCtx];
    [mutableDict setValue:self.shopUuid forKey:kaddCommodityRequestModelShopUuid];
    [mutableDict setValue:self.goodsUuid forKey:kaddCommodityRequestModelGoodsUuid];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operCtx = [aDecoder decodeObjectForKey:kaddCommodityRequestModelOperCtx];
    self.shopUuid = [aDecoder decodeObjectForKey:kaddCommodityRequestModelShopUuid];
    self.goodsUuid = [aDecoder decodeObjectForKey:kaddCommodityRequestModelGoodsUuid];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operCtx forKey:kaddCommodityRequestModelOperCtx];
    [aCoder encodeObject:_shopUuid forKey:kaddCommodityRequestModelShopUuid];
    [aCoder encodeObject:_goodsUuid forKey:kaddCommodityRequestModelGoodsUuid];
}

- (id)copyWithZone:(NSZone *)zone
{
    addCommodityRequestModel *copy = [[addCommodityRequestModel alloc] init];
    
    if (copy) {

        copy.operCtx = [self.operCtx copyWithZone:zone];
        copy.shopUuid = [self.shopUuid copyWithZone:zone];
        copy.goodsUuid = [self.goodsUuid copyWithZone:zone];
    }
    
    return copy;
}


@end
