//
//  Orders.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "Orders.h"


NSString *const kOrdersField = @"field";
NSString *const kOrdersDirection = @"direction";


@interface Orders ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation Orders

@synthesize field = _field;
@synthesize direction = _direction;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.field = [self objectOrNilForKey:kOrdersField fromDictionary:dict];
            self.direction = [self objectOrNilForKey:kOrdersDirection fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.field forKey:kOrdersField];
    [mutableDict setValue:self.direction forKey:kOrdersDirection];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.field = [aDecoder decodeObjectForKey:kOrdersField];
    self.direction = [aDecoder decodeObjectForKey:kOrdersDirection];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_field forKey:kOrdersField];
    [aCoder encodeObject:_direction forKey:kOrdersDirection];
}

- (id)copyWithZone:(NSZone *)zone
{
    Orders *copy = [[Orders alloc] init];
    
    if (copy) {

        copy.field = [self.field copyWithZone:zone];
        copy.direction = [self.direction copyWithZone:zone];
    }
    
    return copy;
}


@end
