//
//  Operator.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "Operator.h"


NSString *const kOperatorId = @"id";
NSString *const kOperatorFullName = @"fullName";


@interface Operator ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation Operator

@synthesize operatorIdentifier = _operatorIdentifier;
@synthesize fullName = _fullName;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operatorIdentifier = [self objectOrNilForKey:kOperatorId fromDictionary:dict];
            self.fullName = [self objectOrNilForKey:kOperatorFullName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.operatorIdentifier forKey:kOperatorId];
    [mutableDict setValue:self.fullName forKey:kOperatorFullName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operatorIdentifier = [aDecoder decodeObjectForKey:kOperatorId];
    self.fullName = [aDecoder decodeObjectForKey:kOperatorFullName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operatorIdentifier forKey:kOperatorId];
    [aCoder encodeObject:_fullName forKey:kOperatorFullName];
}

- (id)copyWithZone:(NSZone *)zone
{
    Operator *copy = [[Operator alloc] init];
    
    if (copy) {

        copy.operatorIdentifier = [self.operatorIdentifier copyWithZone:zone];
        copy.fullName = [self.fullName copyWithZone:zone];
    }
    
    return copy;
}


@end
