//
//  Conditions.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "Conditions.h"
#import "Parameters.h"
#import "Parameter.h"


NSString *const kConditionsParameters = @"parameters";
NSString *const kConditionsOperation = @"operation";
NSString *const kConditionsParameter = @"parameter";


@interface Conditions ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation Conditions

@synthesize parameters = _parameters;
@synthesize operation = _operation;
@synthesize parameter = _parameter;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
    NSObject *receivedParameters = [dict objectForKey:kConditionsParameters];
    NSMutableArray *parsedParameters = [NSMutableArray array];
    if ([receivedParameters isKindOfClass:[NSArray class]]) {
        for (NSDictionary *item in (NSArray *)receivedParameters) {
            if ([item isKindOfClass:[NSDictionary class]]) {
                [parsedParameters addObject:[Parameters modelObjectWithDictionary:item]];
            }
       }
    } else if ([receivedParameters isKindOfClass:[NSDictionary class]]) {
       [parsedParameters addObject:[Parameters modelObjectWithDictionary:(NSDictionary *)receivedParameters]];
    }

    self.parameters = [NSArray arrayWithArray:parsedParameters];
            self.operation = [self objectOrNilForKey:kConditionsOperation fromDictionary:dict];
            self.parameter = [Parameter modelObjectWithDictionary:[dict objectForKey:kConditionsParameter]];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    NSMutableArray *tempArrayForParameters = [NSMutableArray array];
    for (NSObject *subArrayObject in self.parameters) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForParameters addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForParameters addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForParameters] forKey:kConditionsParameters];
    [mutableDict setValue:self.operation forKey:kConditionsOperation];
    [mutableDict setValue:[self.parameter dictionaryRepresentation] forKey:kConditionsParameter];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.parameters = [aDecoder decodeObjectForKey:kConditionsParameters];
    self.operation = [aDecoder decodeObjectForKey:kConditionsOperation];
    self.parameter = [aDecoder decodeObjectForKey:kConditionsParameter];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_parameters forKey:kConditionsParameters];
    [aCoder encodeObject:_operation forKey:kConditionsOperation];
    [aCoder encodeObject:_parameter forKey:kConditionsParameter];
}

- (id)copyWithZone:(NSZone *)zone
{
    Conditions *copy = [[Conditions alloc] init];
    
    if (copy) {

        copy.parameters = [self.parameters copyWithZone:zone];
        copy.operation = [self.operation copyWithZone:zone];
        copy.parameter = [self.parameter copyWithZone:zone];
    }
    
    return copy;
}


@end
