//
//  CommotityRequestModel.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityRequestModel.h"
#import "Defintion.h"


NSString *const kCommotityRequestModelDefintion = @"defintion";
NSString *const kCommotityRequestModelFetchParts = @"fetchParts";


@interface CommotityRequestModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityRequestModel

@synthesize defintion = _defintion;
@synthesize fetchParts = _fetchParts;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.defintion = [Defintion modelObjectWithDictionary:[dict objectForKey:kCommotityRequestModelDefintion]];
            self.fetchParts = [self objectOrNilForKey:kCommotityRequestModelFetchParts fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.defintion dictionaryRepresentation] forKey:kCommotityRequestModelDefintion];
    NSMutableArray *tempArrayForFetchParts = [NSMutableArray array];
    for (NSObject *subArrayObject in self.fetchParts) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForFetchParts addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForFetchParts addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForFetchParts] forKey:kCommotityRequestModelFetchParts];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.defintion = [aDecoder decodeObjectForKey:kCommotityRequestModelDefintion];
    self.fetchParts = [aDecoder decodeObjectForKey:kCommotityRequestModelFetchParts];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_defintion forKey:kCommotityRequestModelDefintion];
    [aCoder encodeObject:_fetchParts forKey:kCommotityRequestModelFetchParts];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityRequestModel *copy = [[CommotityRequestModel alloc] init];
    
    if (copy) {

        copy.defintion = [self.defintion copyWithZone:zone];
        copy.fetchParts = [self.fetchParts copyWithZone:zone];
    }
    
    return copy;
}


@end
