//
//  JavenShop.m
//
//  Created by Z  on 16/4/14
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenShop.h"
#import "JavenOwner.h"
#import "JavenLastModifyInfo.h"
#import "JavenCreateInfo.h"


NSString *const kJavenShopDays7Refund = @"days7Refund";
NSString *const kJavenShopCode = @"code";
NSString *const kJavenShopOwner = @"owner";
NSString *const kJavenShopUpper = @"upper";
NSString *const kJavenShopUuid = @"uuid";
NSString *const kJavenShopPath = @"path";
NSString *const kJavenShopLastModifyInfo = @"lastModifyInfo";
NSString *const kJavenShopContact = @"contact";
NSString *const kJavenShopVersion = @"version";
NSString *const kJavenShopFavorited = @"favorited";
NSString *const kJavenShopName = @"name";
NSString *const kJavenShopState = @"state";
NSString *const kJavenShopDomain = @"domain";
NSString *const kJavenShopRoles = @"roles";
NSString *const kJavenShopUpperOrgPath = @"upperOrgPath";
NSString *const kJavenShopGrade = @"grade";
NSString *const kJavenShopSiteDomain = @"siteDomain";
NSString *const kJavenShopPictures = @"pictures";
NSString *const kJavenShopCreateInfo = @"createInfo";
NSString *const kJavenShopOrder = @"order";
NSString *const kJavenShopDescription = @"description";


@interface JavenShop ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenShop

@synthesize days7Refund = _days7Refund;
@synthesize code = _code;
@synthesize owner = _owner;
@synthesize upper = _upper;
@synthesize uuid = _uuid;
@synthesize path = _path;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize contact = _contact;
@synthesize version = _version;
@synthesize favorited = _favorited;
@synthesize name = _name;
@synthesize state = _state;
@synthesize domain = _domain;
@synthesize roles = _roles;
@synthesize upperOrgPath = _upperOrgPath;
@synthesize grade = _grade;
@synthesize siteDomain = _siteDomain;
@synthesize pictures = _pictures;
@synthesize createInfo = _createInfo;
@synthesize order = _order;
@synthesize shopDescription = _shopDescription;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.days7Refund = [[self objectOrNilForKey:kJavenShopDays7Refund fromDictionary:dict] boolValue];
            self.code = [self objectOrNilForKey:kJavenShopCode fromDictionary:dict];
            self.owner = [JavenOwner modelObjectWithDictionary:[dict objectForKey:kJavenShopOwner]];
            self.upper = [self objectOrNilForKey:kJavenShopUpper fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kJavenShopUuid fromDictionary:dict];
            self.path = [self objectOrNilForKey:kJavenShopPath fromDictionary:dict];
            self.lastModifyInfo = [JavenLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopLastModifyInfo]];
            self.contact = [self objectOrNilForKey:kJavenShopContact fromDictionary:dict];
            self.version = [[self objectOrNilForKey:kJavenShopVersion fromDictionary:dict] doubleValue];
            self.favorited = [[self objectOrNilForKey:kJavenShopFavorited fromDictionary:dict] doubleValue];
            self.name = [self objectOrNilForKey:kJavenShopName fromDictionary:dict];
            self.state = [self objectOrNilForKey:kJavenShopState fromDictionary:dict];
            self.domain = [self objectOrNilForKey:kJavenShopDomain fromDictionary:dict];
            self.roles = [self objectOrNilForKey:kJavenShopRoles fromDictionary:dict];
            self.upperOrgPath = [self objectOrNilForKey:kJavenShopUpperOrgPath fromDictionary:dict];
            self.grade = [[self objectOrNilForKey:kJavenShopGrade fromDictionary:dict] doubleValue];
            self.siteDomain = [self objectOrNilForKey:kJavenShopSiteDomain fromDictionary:dict];
            self.pictures = [self objectOrNilForKey:kJavenShopPictures fromDictionary:dict];
            self.createInfo = [JavenCreateInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopCreateInfo]];
            self.order = [[self objectOrNilForKey:kJavenShopOrder fromDictionary:dict] doubleValue];
            self.shopDescription = [self objectOrNilForKey:kJavenShopDescription fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithBool:self.days7Refund] forKey:kJavenShopDays7Refund];
    [mutableDict setValue:self.code forKey:kJavenShopCode];
    [mutableDict setValue:[self.owner dictionaryRepresentation] forKey:kJavenShopOwner];
    [mutableDict setValue:self.upper forKey:kJavenShopUpper];
    [mutableDict setValue:self.uuid forKey:kJavenShopUuid];
    [mutableDict setValue:self.path forKey:kJavenShopPath];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kJavenShopLastModifyInfo];
    [mutableDict setValue:self.contact forKey:kJavenShopContact];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kJavenShopVersion];
    [mutableDict setValue:[NSNumber numberWithDouble:self.favorited] forKey:kJavenShopFavorited];
    [mutableDict setValue:self.name forKey:kJavenShopName];
    [mutableDict setValue:self.state forKey:kJavenShopState];
    [mutableDict setValue:self.domain forKey:kJavenShopDomain];
    NSMutableArray *tempArrayForRoles = [NSMutableArray array];
    for (NSObject *subArrayObject in self.roles) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForRoles addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForRoles addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForRoles] forKey:kJavenShopRoles];
    [mutableDict setValue:self.upperOrgPath forKey:kJavenShopUpperOrgPath];
    [mutableDict setValue:[NSNumber numberWithDouble:self.grade] forKey:kJavenShopGrade];
    [mutableDict setValue:self.siteDomain forKey:kJavenShopSiteDomain];
    [mutableDict setValue:self.pictures forKey:kJavenShopPictures];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kJavenShopCreateInfo];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kJavenShopOrder];
    [mutableDict setValue:self.shopDescription forKey:kJavenShopDescription];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.days7Refund = [aDecoder decodeBoolForKey:kJavenShopDays7Refund];
    self.code = [aDecoder decodeObjectForKey:kJavenShopCode];
    self.owner = [aDecoder decodeObjectForKey:kJavenShopOwner];
    self.upper = [aDecoder decodeObjectForKey:kJavenShopUpper];
    self.uuid = [aDecoder decodeObjectForKey:kJavenShopUuid];
    self.path = [aDecoder decodeObjectForKey:kJavenShopPath];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kJavenShopLastModifyInfo];
    self.contact = [aDecoder decodeObjectForKey:kJavenShopContact];
    self.version = [aDecoder decodeDoubleForKey:kJavenShopVersion];
    self.favorited = [aDecoder decodeDoubleForKey:kJavenShopFavorited];
    self.name = [aDecoder decodeObjectForKey:kJavenShopName];
    self.state = [aDecoder decodeObjectForKey:kJavenShopState];
    self.domain = [aDecoder decodeObjectForKey:kJavenShopDomain];
    self.roles = [aDecoder decodeObjectForKey:kJavenShopRoles];
    self.upperOrgPath = [aDecoder decodeObjectForKey:kJavenShopUpperOrgPath];
    self.grade = [aDecoder decodeDoubleForKey:kJavenShopGrade];
    self.siteDomain = [aDecoder decodeObjectForKey:kJavenShopSiteDomain];
    self.pictures = [aDecoder decodeObjectForKey:kJavenShopPictures];
    self.createInfo = [aDecoder decodeObjectForKey:kJavenShopCreateInfo];
    self.order = [aDecoder decodeDoubleForKey:kJavenShopOrder];
    self.shopDescription = [aDecoder decodeObjectForKey:kJavenShopDescription];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeBool:_days7Refund forKey:kJavenShopDays7Refund];
    [aCoder encodeObject:_code forKey:kJavenShopCode];
    [aCoder encodeObject:_owner forKey:kJavenShopOwner];
    [aCoder encodeObject:_upper forKey:kJavenShopUpper];
    [aCoder encodeObject:_uuid forKey:kJavenShopUuid];
    [aCoder encodeObject:_path forKey:kJavenShopPath];
    [aCoder encodeObject:_lastModifyInfo forKey:kJavenShopLastModifyInfo];
    [aCoder encodeObject:_contact forKey:kJavenShopContact];
    [aCoder encodeDouble:_version forKey:kJavenShopVersion];
    [aCoder encodeDouble:_favorited forKey:kJavenShopFavorited];
    [aCoder encodeObject:_name forKey:kJavenShopName];
    [aCoder encodeObject:_state forKey:kJavenShopState];
    [aCoder encodeObject:_domain forKey:kJavenShopDomain];
    [aCoder encodeObject:_roles forKey:kJavenShopRoles];
    [aCoder encodeObject:_upperOrgPath forKey:kJavenShopUpperOrgPath];
    [aCoder encodeDouble:_grade forKey:kJavenShopGrade];
    [aCoder encodeObject:_siteDomain forKey:kJavenShopSiteDomain];
    [aCoder encodeObject:_pictures forKey:kJavenShopPictures];
    [aCoder encodeObject:_createInfo forKey:kJavenShopCreateInfo];
    [aCoder encodeDouble:_order forKey:kJavenShopOrder];
    [aCoder encodeObject:_shopDescription forKey:kJavenShopDescription];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenShop *copy = [[JavenShop alloc] init];
    
    if (copy) {

        copy.days7Refund = self.days7Refund;
        copy.code = [self.code copyWithZone:zone];
        copy.owner = [self.owner copyWithZone:zone];
        copy.upper = [self.upper copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.path = [self.path copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.contact = [self.contact copyWithZone:zone];
        copy.version = self.version;
        copy.favorited = self.favorited;
        copy.name = [self.name copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.domain = [self.domain copyWithZone:zone];
        copy.roles = [self.roles copyWithZone:zone];
        copy.upperOrgPath = [self.upperOrgPath copyWithZone:zone];
        copy.grade = self.grade;
        copy.siteDomain = [self.siteDomain copyWithZone:zone];
        copy.pictures = [self.pictures copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.order = self.order;
        copy.shopDescription = [self.shopDescription copyWithZone:zone];
    }
    
    return copy;
}


@end
