//
//  JavenOwner.m
//
//  Created by Z  on 16/4/14
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenOwner.h"


NSString *const kJavenOwnerName = @"name";
NSString *const kJavenOwnerUuid = @"uuid";
NSString *const kJavenOwnerCode = @"code";


@interface JavenOwner ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenOwner

@synthesize name = _name;
@synthesize uuid = _uuid;
@synthesize code = _code;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kJavenOwnerName fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kJavenOwnerUuid fromDictionary:dict];
            self.code = [self objectOrNilForKey:kJavenOwnerCode fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kJavenOwnerName];
    [mutableDict setValue:self.uuid forKey:kJavenOwnerUuid];
    [mutableDict setValue:self.code forKey:kJavenOwnerCode];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kJavenOwnerName];
    self.uuid = [aDecoder decodeObjectForKey:kJavenOwnerUuid];
    self.code = [aDecoder decodeObjectForKey:kJavenOwnerCode];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kJavenOwnerName];
    [aCoder encodeObject:_uuid forKey:kJavenOwnerUuid];
    [aCoder encodeObject:_code forKey:kJavenOwnerCode];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenOwner *copy = [[JavenOwner alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
    }
    
    return copy;
}


@end
