//
//  JavenOperator.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenOperator.h"


NSString *const kJavenOperatorId = @"id";
NSString *const kJavenOperatorFullName = @"fullName";


@interface JavenOperator ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenOperator

@synthesize operatorIdentifier = _operatorIdentifier;
@synthesize fullName = _fullName;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operatorIdentifier = [self objectOrNilForKey:kJavenOperatorId fromDictionary:dict];
            self.fullName = [self objectOrNilForKey:kJavenOperatorFullName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.operatorIdentifier forKey:kJavenOperatorId];
    [mutableDict setValue:self.fullName forKey:kJavenOperatorFullName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operatorIdentifier = [aDecoder decodeObjectForKey:kJavenOperatorId];
    self.fullName = [aDecoder decodeObjectForKey:kJavenOperatorFullName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operatorIdentifier forKey:kJavenOperatorId];
    [aCoder encodeObject:_fullName forKey:kJavenOperatorFullName];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenOperator *copy = [[JavenOperator alloc] init];
    
    if (copy) {

        copy.operatorIdentifier = [self.operatorIdentifier copyWithZone:zone];
        copy.fullName = [self.fullName copyWithZone:zone];
    }
    
    return copy;
}


@end
