//
//  JavenLastModifyInfo.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenLastModifyInfo.h"
#import "JavenOperator.h"


NSString *const kJavenLastModifyInfoOperator = @"operator";
NSString *const kJavenLastModifyInfoTime = @"time";


@interface JavenLastModifyInfo ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenLastModifyInfo

@synthesize operator = _operator;
@synthesize time = _time;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operator = [JavenOperator modelObjectWithDictionary:[dict objectForKey:kJavenLastModifyInfoOperator]];
            self.time = [[self objectOrNilForKey:kJavenLastModifyInfoTime fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.operator dictionaryRepresentation] forKey:kJavenLastModifyInfoOperator];
    [mutableDict setValue:[NSNumber numberWithDouble:self.time] forKey:kJavenLastModifyInfoTime];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operator = [aDecoder decodeObjectForKey:kJavenLastModifyInfoOperator];
    self.time = [aDecoder decodeDoubleForKey:kJavenLastModifyInfoTime];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operator forKey:kJavenLastModifyInfoOperator];
    [aCoder encodeDouble:_time forKey:kJavenLastModifyInfoTime];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenLastModifyInfo *copy = [[JavenLastModifyInfo alloc] init];
    
    if (copy) {

        copy.operator = [self.operator copyWithZone:zone];
        copy.time = self.time;
    }
    
    return copy;
}


@end
