//
//  JavenCreateInfo.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenCreateInfo.h"
#import "JavenOperator.h"


NSString *const kJavenCreateInfoOperator = @"operator";
NSString *const kJavenCreateInfoTime = @"time";


@interface JavenCreateInfo ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenCreateInfo

@synthesize operator = _operator;
@synthesize time = _time;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operator = [JavenOperator modelObjectWithDictionary:[dict objectForKey:kJavenCreateInfoOperator]];
            self.time = [[self objectOrNilForKey:kJavenCreateInfoTime fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.operator dictionaryRepresentation] forKey:kJavenCreateInfoOperator];
    [mutableDict setValue:[NSNumber numberWithDouble:self.time] forKey:kJavenCreateInfoTime];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operator = [aDecoder decodeObjectForKey:kJavenCreateInfoOperator];
    self.time = [aDecoder decodeDoubleForKey:kJavenCreateInfoTime];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operator forKey:kJavenCreateInfoOperator];
    [aCoder encodeDouble:_time forKey:kJavenCreateInfoTime];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenCreateInfo *copy = [[JavenCreateInfo alloc] init];
    
    if (copy) {

        copy.operator = [self.operator copyWithZone:zone];
        copy.time = self.time;
    }
    
    return copy;
}


@end
