//
//  JavenCategory.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenCategory.h"


NSString *const kJavenCategoryName = @"name";
NSString *const kJavenCategoryCode = @"code";
NSString *const kJavenCategoryUuid = @"uuid";


@interface JavenCategory ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenCategory

@synthesize name = _name;
@synthesize code = _code;
@synthesize uuid = _uuid;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kJavenCategoryName fromDictionary:dict];
            self.code = [self objectOrNilForKey:kJavenCategoryCode fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kJavenCategoryUuid fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kJavenCategoryName];
    [mutableDict setValue:self.code forKey:kJavenCategoryCode];
    [mutableDict setValue:self.uuid forKey:kJavenCategoryUuid];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kJavenCategoryName];
    self.code = [aDecoder decodeObjectForKey:kJavenCategoryCode];
    self.uuid = [aDecoder decodeObjectForKey:kJavenCategoryUuid];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kJavenCategoryName];
    [aCoder encodeObject:_code forKey:kJavenCategoryCode];
    [aCoder encodeObject:_uuid forKey:kJavenCategoryUuid];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenCategory *copy = [[JavenCategory alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
    }
    
    return copy;
}


@end
