//
//  GXFButtonAndLineView.m
//  XFFruit
//
//  Created by freecui on 15/9/4.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFButtonAndLineView.h"

@implementation GXFButtonAndLineView

- (instancetype)initViewLineAndButtonWithFrame: (CGRect)frame
                                     isSeleted: (BOOL)isSelected
                                   buttonTitle: (NSString *)title
                                   selectColor: (UIColor *)color {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(0, 0, self.width, self.height - 3);
    [btn setTitle:title forState:UIControlStateNormal];
   
    
    CGSize labelSize = [btn.titleLabel.text sizeWithAttributes:@{NSFontAttributeName: btn.titleLabel.font}];
//    UIView *line = [[UIView alloc]initWithFrame:CGRectMake((self.width - labelSize.width ) * 0.5, btn.bottom, labelSize.width, 3)];
    UIView *line = [[UIView alloc]initWithFrame:CGRectMake(0, btn.bottom, self.width, 3)];
    if (isSelected) {
        [btn setTitleColor:color forState:UIControlStateNormal];
        line.backgroundColor = color;
        
    } else {
        [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        line.backgroundColor = [UIColor whiteColor];
    }
    
    self.f_btn = btn;
    self.f_line = line;
    [self addSubview:line];
    [self addSubview:btn];
    
    return self;
    

}
- (instancetype)initViewLineAndButtonWithFrame: (CGRect)frame
                             isSeleted: (BOOL)isSelected
                           buttonTitle: (NSString *)title
                           selectColor: (UIColor *)color
                                action:(SEL)action
                      forControlEvents:(UIControlEvents)controlEvents
{
   
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(0, 0, self.width, self.height - 1);
    [btn setTitle:title forState:UIControlStateNormal];
    [btn addTarget:self action:action forControlEvents:controlEvents];
    
    CGSize labelSize = [btn.titleLabel.text sizeWithAttributes:@{NSFontAttributeName: btn.titleLabel.font}];
    UIView *line = [[UIView alloc]initWithFrame:CGRectMake((self.width - labelSize.width ) * 0.5, btn.bottom, labelSize.width, 1)];
    if (isSelected) {
        [btn setTitleColor:color forState:UIControlStateNormal];
        line.backgroundColor = color;
        
    } else {
        [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        line.backgroundColor = [UIColor whiteColor];
    }
    
    self.f_btn = btn;
    self.f_line = line;
    [self addSubview:line];
    [self addSubview:btn];
    
    return self;
    
    
}


@end
