//
//  UIView+Category.m
//  ALand
//
//  Created by Z on 16/3/22.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "UIView+Category.h"

@implementation UIView (Category)



+ (id)viewWithNibName:(NSString *)viewName {
    NSArray* nibView =  [[NSBundle mainBundle] loadNibNamed:viewName owner:nil options:nil];
    return [nibView objectAtIndex:0];
}

- (UIViewController *)viewController
{
    for (UIView* next = [self superview]; next; next = next.superview) {
        UIResponder *nextResponder = [next nextResponder];
        if ([nextResponder isKindOfClass:[IBTUIViewController class]]) {
            return (UIViewController *)nextResponder;
        }
    }
    return nil;
}
@end
