//
//  UIImage+Helper.h
//  CXA
//
//  Created by Xummer on 14-3-3.
//  Copyright (c) 2014年 Xummer. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage (Helper)

+ (UIImage *)getThumbnailImage:(UIImage *)image withMaxLen:(CGFloat)maxLen;
- (UIImage *)thumbnailWithMaxLen:(CGFloat)maxLen;

- (UIImage *)imageWithTintColor:(UIColor *)tintColor;

- (UIImage *)imageWithGradientTintColor:(UIColor *)tintColor;

- (UIImage *)imageWithTintColor:(UIColor *)tintColor blendMode:(CGBlendMode)blendMode;

@end

@interface UIImage (Color)
+ (UIImage *)imageWithColor:(UIColor *)color;
+ (UIImage *)imageWithColor:(UIColor *)color andSize:(CGSize)size;
+ (UIImage *)imageWithColor:(UIColor *)color andRect:(CGRect)rect;
- (UIImage *)greyScaleImage;
/**
 *  图片压缩到指定大小（具体看图片大小，过大的图片无法压缩到指定大小）
 *
 *  @param kb 压缩后图片大小
 *
 *  @return
 */
- (NSData *)scaledToSpaceMaxSize:(NSInteger)kb;

/**
 *  压缩图片到指定高宽
 *
 *  @param newSize 新的图片尺寸
 *
 *  @return
 */
- (UIImage *)scaledToSize:(CGSize)newSize;

/**
 *  按比例压缩图片至指定宽度
 *
 *  @param newWidth 指定宽度
 *
 *  @return
 */
- (UIImage *)scaledToWidth:(NSInteger)newWidth;

@end
