//
//  MBProgressHUD+Javen.h
//  ALand
//
//  Created by Z on 16/4/14.
//  Copyright © 2016年 Z. All rights reserved.
//

#import <MBProgressHUD/MBProgressHUD.h>
typedef void (^succeBlock)(void);
@interface MBProgressHUD (Javen)

@property (nonatomic, copy) succeBlock success;
+ (void)showSuccess:(NSString *)success;
+ (void)showSuccess:(NSString *)success toView:(UIView *)view;

+ (void)showError:(NSString *)error;
+ (void)showError:(NSString *)error toView:(UIView *)view;
/**
 *  显示错误信息
 *
 *  @param message 信息内容
 *
 *  @return 直接返回一个MBProgressHUD，需要手动关闭
 */
+ (MBProgressHUD *)showMessage:(NSString *)message;
+ (MBProgressHUD *)showMessage:(NSString *)message toView:(UIView *)view;

+ (void)hideHUD;
+ (void)hideHUDForView:(UIView *)view;


+ (MBProgressHUD *)Javen_showMessage:(NSString *)message onView:(UIView *)view;


+ (MBProgressHUD *)Javen_showSuccess:(NSString *)success onView:(UIView *)view delay:(NSTimeInterval)time complete:(void (^)(void))complete;
+ (void)Javen_showError:(NSString *)error onView:(UIView *)view delay:(NSTimeInterval)time complete:(void (^)(void))complete;
@end
