//
//  LoginViewController.m
//  ALand
//
//  Created by Z on 16/3/17.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "LoginViewController.h"
#import "ToLoginViewController.h"
#import "RigistViewController.h"
#import "BaseViewController.h"
@interface LoginViewController ()
@property (weak, nonatomic) IBOutlet UIButton *buttonQQ;
@property (weak, nonatomic) IBOutlet UIButton *buttonWX;
@property (weak, nonatomic) IBOutlet UIButton *buttonWeibo;

@end

@implementation LoginViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    self.buttonQQ.imageView.contentMode = UIViewContentModeScaleAspectFit;
    self.buttonWX.imageView.contentMode = UIViewContentModeScaleAspectFit;
    self.buttonWeibo.imageView.contentMode = UIViewContentModeScaleAspectFit;
    // Do any additional setup after loading the view.
}

- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleDefault;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:YES];
    
    
    [self defaultLoginAction];
    
}

//本地已有密码时登录
- (void)defaultLoginAction {
    if ([[NSUserDefaults standardUserDefaults] objectForKey:@"passWord"]) {
        
        NSDictionary *paramers = @{@"domain":kDomain,
                                   @"loginName":[[NSUserDefaults standardUserDefaults] objectForKey:@"userName"] ,
                                   @"password":[[NSUserDefaults standardUserDefaults] objectForKey:@"passWord"],
                                   @"rememberMe":@"true"};
        [MBProgressHUD showHUDAddedTo:self.view animated:YES];
        WS(weakSelf)
        [[HTTPCilent shareCilent] POST:@"app/resellerLogin" parameters:paramers success:^(NSURLSessionDataTask *task, id responseObject) {
            
            [MBProgressHUD hideHUDForView:self.view animated:YES];
            
            if ([responseObject[@"code"] isEqualToNumber:@0]) {
                
                UserInfo *info = [UserInfo shareInstance];
                [info UserInfoWithDictionary:responseObject[@"reseller"]];
                BaseViewController *baseVC = [[BaseViewController alloc] init];
                baseVC.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
                [weakSelf presentViewController:baseVC animated:YES completion:nil];
                
            }else{
                [[NSUserDefaults standardUserDefaults] setObject:nil forKey:@"passWord"];
                [MBProgressHUD Javen_showError:responseObject[@"message"] onView:weakSelf.view delay:2 complete:nil];
            }
        } failure:^(NSURLSessionDataTask *task, NSError *error) {
             [MBProgressHUD hideHUDForView:self.view animated:YES];
        }];
        

    }
}


- (IBAction)rigistAction:(UIButton *)sender {
    RigistViewController *rigistVC = [[RigistViewController alloc] initWithNibName:@"RigistViewController" bundle:[NSBundle mainBundle]];
    [self.navigationController pushViewController:rigistVC animated:YES];
}


- (IBAction)loginACtion:(UIButton *)sender {
    ToLoginViewController *toLoginVC = [[ToLoginViewController alloc] initWithNibName:@"ToLoginViewController" bundle:[NSBundle mainBundle]];

    [self.navigationController pushViewController:toLoginVC animated:YES];
}


- (IBAction)toTencentLogin:(UIButton *)sender {
    
}

- (IBAction)toWeiChatLogin:(id)sender {
}

- (IBAction)toWeiboLogin:(id)sender {
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
