//
//  introductionViewController.m
//  ALand
//
//  Created by Z on 16/4/7.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "introductionViewController.h"

@interface introductionViewController ()
@property (weak, nonatomic) IBOutlet UITextView *textViewInstroduction;

@end

@implementation introductionViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
}
- (IBAction)safeIntroductionAction:(id)sender {
    [self.view endEditing:YES];
    UserInfo *user = [UserInfo shareInstance];
    self.shopModel.internalBaseClassDescription = self.textViewInstroduction.text;
    
    [JavenShopModel mj_setupReplacedKeyFromPropertyName:^NSDictionary *{
        return @{@"operatorIdentifier":@"id"};
    }];
    NSDictionary *dicShop = [self.shopModel dictionaryRepresentation];
    
    NSDictionary *params = @{@"operCtx" : @{@"time" : [[NSDate date] timeStampNumber],
                                            @"domain" : user.domain,
                                            @"operator" : @{@"id" : user.uuid,
                                                            @"fullName" : user.name}},
                             @"shop" : dicShop};
    
    MBProgressHUD *hud = [MBProgressHUD Javen_showMessage:@"修改中" onView:self.view];
    WS(weakSelf)
    
    [[HTTPCilent shareCilent] POST:@"shop/save" parameters:params success:^(NSURLSessionDataTask *task, id responseObject) {
        if ([responseObject[@"code"] isEqualToNumber:@0]) {
            
            [hud hide:YES];
            [MBProgressHUD Javen_showSuccess:@"修改成功！" onView:weakSelf.view  delay:0.7 complete:^{
                
                [weakSelf popAction];
            }];
        }
        
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
