//
//  StoreQRCodeViewController.m
//  ALand
//
//  Created by Z on 16/4/5.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "StoreQRCodeViewController.h"
#import "UIImage+QRCode.h"
@interface StoreQRCodeViewController ()
@property (weak, nonatomic) IBOutlet UIImageView *imageViewQRCode;

@end

@implementation StoreQRCodeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    UIImage *qrcode = [UIImage createNonInterpolatedUIImageFormCIImage:[UIImage createQRForString:@"http://list.jd.hk/list.html?cat=1319%2C1527%2C1556&gjz=0&go=0"] withSize:250.0f];
    UIImage *customQrcode = [UIImage imageBlackToTransparent:qrcode withRed:60.0f andGreen:74.0f andBlue:89.0f];
    self.imageViewQRCode.image = customQrcode;
    // set shadow
    self.imageViewQRCode.layer.shadowOffset = CGSizeMake(0, 2);
    self.imageViewQRCode.layer.shadowRadius = 2;
    self.imageViewQRCode.layer.shadowColor = [UIColor blackColor].CGColor;
    self.imageViewQRCode.layer.shadowOpacity = 0.5;
    // Do any additional setup after loading the view from its nib.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:YES];
}
- (IBAction)actionSafeToAlbum:(id)sender {
}

- (IBAction)actionShare:(id)sender {
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
