//
//  StoreNameViewController.m
//  ALand
//
//  Created by Z on 16/4/7.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "StoreNameViewController.h"

@interface StoreNameViewController ()
@property (weak, nonatomic) IBOutlet UITextField *textFieldName;

@end

@implementation StoreNameViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"店铺名称";
    // Do any additional setup after loading the view from its nib.
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}



- (IBAction)saveName:(id)sender {
    [self.view endEditing:YES];
    UserInfo *user = [UserInfo shareInstance];
    self.shopModel.name = self.textFieldName.text;
    
    [JavenShopModel mj_setupReplacedKeyFromPropertyName:^NSDictionary *{
        return @{@"operatorIdentifier":@"id"};
    }];
    NSDictionary *dicShop = [self.shopModel dictionaryRepresentation];
    
    NSDictionary *params = @{@"operCtx" : @{@"time" : [[NSDate date] timeStampNumber],
                                                  @"domain" : user.domain,
                                                  @"operator" : @{@"id" : user.uuid,
                                                                  @"fullName" : user.name}},
                                   @"shop" : dicShop};
    
    
    
    WS(weakSelf)
     MBProgressHUD *hud = [MBProgressHUD Javen_showMessage:@"修改中" onView:self.view];
    [[HTTPCilent shareCilent] POST:@"shop/save" parameters:params success:^(NSURLSessionDataTask *task, id responseObject) {
        if ([responseObject[@"code"] isEqualToNumber:@0]) {
            
            [hud hide:YES];
            [MBProgressHUD Javen_showSuccess:@"修改成功！" onView:weakSelf.view  delay:0.7 complete:^{
                
                [weakSelf popAction];
            }];
        }
        
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
    
    
    
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
