//
//  OrderViewController.m
//  ALand
//
//  Created by Z on 16/3/30.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "OrderViewController.h"
#import "JavenMultipleViewWithHeader.h"
#import "NoPaymentTableViewController.h"
@interface OrderViewController ()
@property (nonatomic, strong) JavenMultipleViewWithHeader *viewMutiple;
@end

@implementation OrderViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"订单管理";
    [self setUpView];
    

    // Do any additional setup after loading the view.
}


- (void)setUpView {
    
    NSArray *arrTitle = @[@"代支付",@"待发货",@"已发货",@"已完成",@"已取消"];
    
    NSMutableArray *arrVC = [NSMutableArray array];
    for (int i; i < arrTitle.count; i++) {
        NoPaymentTableViewController *noPayMentVC = [[NoPaymentTableViewController alloc] init];
        noPayMentVC.orderTag = arrTitle[i];
        [arrVC addObject:noPayMentVC];
    }
    
    _viewMutiple = [[JavenMultipleViewWithHeader alloc] initWithFrame:CGRectMake(0, 0, kWidth, kHeight)
                                                                views:arrVC
                                                               titles: arrTitle
                                                               target:self
                                                      selectTextColor:kCustomGreenColor
                                                selectBackgroundColor:kBacroundColor
                                                            textColor:kTextColorBlack
                                                      backgroundColor:kBacroundColor
                                                          titleHeight:40
                                                        titleBtnWidth:kWidth / arrTitle.count];
    [self.view addSubview:_viewMutiple];
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
