//
//  MyTeamViewController.m
//  ALand
//
//  Created by Z on 16/4/15.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "MyTeamViewController.h"
#import "MyTeamCollectionViewCell.h"
#import "MyteamTopView.h"

#define kItemId @"MyTeamCollectionViewCell.h"
@interface MyTeamViewController ()<UICollectionViewDelegate, UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation MyTeamViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"我的团队";
    [self setUpCollectionView];
    // Do any additional setup after loading the view.
}

- (void)setUpCollectionView {
    
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    layout.minimumInteritemSpacing = 0;
    layout.minimumLineSpacing = 1;
    layout.itemSize = CGSizeMake(kWidth / 3, kWidth * 2 / 3);
    self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectMake(0, 0, kWidth, kHeight - 64) collectionViewLayout:layout];
    self.collectionView.contentInset = UIEdgeInsetsMake(140, 0, 0, 0);
    self.collectionView.backgroundColor = kBacroundColor;
    self.collectionView.delegate = self;
    self.collectionView.dataSource = self;
    [self.collectionView registerNib:[UINib nibWithNibName:@"MyTeamCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kItemId];
    [self.view addSubview:self.collectionView];
    
    [self setUpTopView];
}

- (void)setUpTopView {
    MyteamTopView *topView = [MyteamTopView viewWithNibName:@"MyTeamTopView"];
    topView.frame = CGRectMake(0, -140 + 20, kWidth, 100);
    [self.collectionView addSubview:topView];
}


#pragma mark =========== collection delegate ===========
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 10;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    MyTeamCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kItemId forIndexPath:indexPath];
    return cell;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
