//
//  CustomerManagementViewController.m
//  ALand
//
//  Created by Z on 16/4/15.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CustomerManagementViewController.h"
#import "UITableView+Category.h"
#import "JavenSortView.h"
#import "CustomerTableViewCell.h"
#define kCellId @"CustomerTableViewCell.h"
@interface CustomerManagementViewController ()<UISearchBarDelegate, UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UISearchBar *searchBar;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) JavenSortView *sortView;
@end

@implementation CustomerManagementViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = kBacroundColor;
    [self setUpSearchBar];
    [self setUpSortView];
    [self setUptableView];
    // Do any additional setup after loading the view.
}

- (void)setUpSearchBar {
    UIView *titleView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kWidth - 60, 35)];//allocate titleView
    UIColor *color = self.navigationController.navigationBar.barTintColor;
    [titleView setBackgroundColor:color];
    self.searchBar = [[UISearchBar alloc] init];
    self.searchBar.tintColor = kTextColorLiteGray;
    self.searchBar.backgroundColor = kRandomColor;
    self.searchBar.delegate = self;
    self.searchBar.placeholder = @"请输入手机号";
    self.searchBar.frame = CGRectMake(0, 0, kWidth - 60, 35);
    self.searchBar.centerX = titleView.centerX;
    self.searchBar.backgroundImage = [UIImage imageWithColor:color];
    [titleView addSubview:self.searchBar];
    self.navigationItem.titleView = titleView;

}

- (void)setUpSortView {
      NSArray *arrLeftTitles =  @[@"全部客户",@"今日新增客户",@"本周新增客户"];
    NSArray *arrRightTitles = @[@"默认排序",@"订单数从高到低",@"收入从高到低"];
    self.sortView = [JavenSortView sortViewLeftTitles:arrLeftTitles rightTitles:arrRightTitles];
    self.sortView.frame = CGRectMake(0, 0, kWidth, 40);
    [self.view addSubview:self.sortView];
}



- (void)setUptableView {
    self.tableView = [UITableView plainTableViewWithTarget:self cellNibName:@"CustomerTableViewCell" cellId:kCellId];
    [self.view addSubview:self.tableView];
    self.tableView.sd_layout.topSpaceToView(self.sortView,0).leftEqualToView(self.view).rightEqualToView(self.view).bottomEqualToView(self.view);
}

#pragma mark =========== tableview delegate ===========
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 10;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomerTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 110;
}

#pragma mark =========== searchbar delegate ===========

- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText
{
    
}

- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar
{
    [self.searchBar endEditing:YES];
}

- (BOOL)searchBarShouldBeginEditing:(UISearchBar *)searchBar
{
    self.searchBar.showsCancelButton = YES;
    return YES;
}

- (BOOL)searchBarShouldEndEditing:(UISearchBar *)searchBar
{
    self.searchBar.showsCancelButton = NO;
    return YES;
}

- (void)cancelSearchAction {


}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
